package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEndpointRequest(endpointArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest = {
    import DeleteEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteEndpointRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteEndpointRequest.wrap(buildAwsValue())
}
object DeleteEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteEndpointRequest =
      zio.aws.databasemigration.model.DeleteEndpointRequest(endpointArn)
    def endpointArn: String
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest
  ) extends zio.aws.databasemigration.model.DeleteEndpointRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest
  ): zio.aws.databasemigration.model.DeleteEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
