package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait DataFormatValue {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.DataFormatValue
}
object DataFormatValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.DataFormatValue
  ): zio.aws.databasemigration.model.DataFormatValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.DataFormatValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.DataFormatValue.CSV =>
      val r = csv
      r
    case software.amazon.awssdk.services.databasemigration.model.DataFormatValue.PARQUET =>
      val r = parquet
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.DataFormatValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DataFormatValue =
      software.amazon.awssdk.services.databasemigration.model.DataFormatValue.UNKNOWN_TO_SDK_VERSION
  }
  case object csv extends zio.aws.databasemigration.model.DataFormatValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DataFormatValue =
      software.amazon.awssdk.services.databasemigration.model.DataFormatValue.CSV
  }
  case object parquet extends zio.aws.databasemigration.model.DataFormatValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DataFormatValue =
      software.amazon.awssdk.services.databasemigration.model.DataFormatValue.PARQUET
  }
}
