package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  SecretString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MongoDbSettings(
    username: Optional[String] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    authType: Optional[zio.aws.databasemigration.model.AuthTypeValue] =
      Optional.Absent,
    authMechanism: Optional[
      zio.aws.databasemigration.model.AuthMechanismValue
    ] = Optional.Absent,
    nestingLevel: Optional[zio.aws.databasemigration.model.NestingLevelValue] =
      Optional.Absent,
    extractDocId: Optional[String] = Optional.Absent,
    docsToInvestigate: Optional[String] = Optional.Absent,
    authSource: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MongoDbSettings = {
    import MongoDbSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(authMechanism.map(value => value.unwrap))(_.authMechanism)
      .optionallyWith(nestingLevel.map(value => value.unwrap))(_.nestingLevel)
      .optionallyWith(extractDocId.map(value => value: java.lang.String))(
        _.extractDocId
      )
      .optionallyWith(docsToInvestigate.map(value => value: java.lang.String))(
        _.docsToInvestigate
      )
      .optionallyWith(authSource.map(value => value: java.lang.String))(
        _.authSource
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.MongoDbSettings.ReadOnly =
    zio.aws.databasemigration.model.MongoDbSettings.wrap(buildAwsValue())
}
object MongoDbSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MongoDbSettings =
      zio.aws.databasemigration.model.MongoDbSettings(
        username.map(value => value),
        password.map(value => value),
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        authType.map(value => value),
        authMechanism.map(value => value),
        nestingLevel.map(value => value),
        extractDocId.map(value => value),
        docsToInvestigate.map(value => value),
        authSource.map(value => value),
        kmsKeyId.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def username: Optional[String]
    def password: Optional[SecretString]
    def serverName: Optional[String]
    def port: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def authType: Optional[zio.aws.databasemigration.model.AuthTypeValue]
    def authMechanism
        : Optional[zio.aws.databasemigration.model.AuthMechanismValue]
    def nestingLevel
        : Optional[zio.aws.databasemigration.model.NestingLevelValue]
    def extractDocId: Optional[String]
    def docsToInvestigate: Optional[String]
    def authSource: Optional[String]
    def kmsKeyId: Optional[String]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getAuthType
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.AuthTypeValue] =
      AwsError.unwrapOptionField("authType", authType)
    def getAuthMechanism: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.AuthMechanismValue
    ] = AwsError.unwrapOptionField("authMechanism", authMechanism)
    def getNestingLevel: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.NestingLevelValue
    ] = AwsError.unwrapOptionField("nestingLevel", nestingLevel)
    def getExtractDocId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("extractDocId", extractDocId)
    def getDocsToInvestigate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("docsToInvestigate", docsToInvestigate)
    def getAuthSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authSource", authSource)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
  ) extends zio.aws.databasemigration.model.MongoDbSettings.ReadOnly {
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val authType
        : Optional[zio.aws.databasemigration.model.AuthTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.databasemigration.model.AuthTypeValue.wrap(value))
    override val authMechanism
        : Optional[zio.aws.databasemigration.model.AuthMechanismValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authMechanism())
        .map(value =>
          zio.aws.databasemigration.model.AuthMechanismValue.wrap(value)
        )
    override val nestingLevel
        : Optional[zio.aws.databasemigration.model.NestingLevelValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nestingLevel())
        .map(value =>
          zio.aws.databasemigration.model.NestingLevelValue.wrap(value)
        )
    override val extractDocId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.extractDocId())
      .map(value => value: String)
    override val docsToInvestigate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.docsToInvestigate())
      .map(value => value: String)
    override val authSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authSource())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
  ): zio.aws.databasemigration.model.MongoDbSettings.ReadOnly = new Wrapper(
    impl
  )
}
