package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationTaskAssessmentRunsRequest(
    filters: Option[Iterable[zio.aws.databasemigration.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest = {
    import DescribeReplicationTaskAssessmentRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationTaskAssessmentRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest =
      zio.aws.databasemigration.model
        .DescribeReplicationTaskAssessmentRunsRequest(
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def filters: Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
  ) extends zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
  ): zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest.ReadOnly =
    new Wrapper(impl)
}
