package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourcePendingMaintenanceActions(
    resourceIdentifier: Option[String] = None,
    pendingMaintenanceActionDetails: Option[
      Iterable[zio.aws.databasemigration.model.PendingMaintenanceAction]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ResourcePendingMaintenanceActions = {
    import ResourcePendingMaintenanceActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ResourcePendingMaintenanceActions
      .builder()
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActionDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly =
    zio.aws.databasemigration.model.ResourcePendingMaintenanceActions
      .wrap(buildAwsValue())
}
object ResourcePendingMaintenanceActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ResourcePendingMaintenanceActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ResourcePendingMaintenanceActions =
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions(
        resourceIdentifier.map(value => value),
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceIdentifier: Option[String]
    def pendingMaintenanceActionDetails: Option[
      List[zio.aws.databasemigration.model.PendingMaintenanceAction.ReadOnly]
    ]
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getPendingMaintenanceActionDetails: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActionDetails",
      pendingMaintenanceActionDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ResourcePendingMaintenanceActions
  ) extends zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly {
    override val resourceIdentifier: Option[String] =
      scala.Option(impl.resourceIdentifier()).map(value => value: String)
    override val pendingMaintenanceActionDetails: Option[
      List[zio.aws.databasemigration.model.PendingMaintenanceAction.ReadOnly]
    ] = scala
      .Option(impl.pendingMaintenanceActionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.PendingMaintenanceAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ResourcePendingMaintenanceActions
  ): zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly =
    new Wrapper(impl)
}
