package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeApplicableIndividualAssessmentsRequest(
    replicationTaskArn: Option[String] = None,
    replicationInstanceArn: Option[String] = None,
    sourceEngineName: Option[String] = None,
    targetEngineName: Option[String] = None,
    migrationType: Option[zio.aws.databasemigration.model.MigrationTypeValue] =
      None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest = {
    import DescribeApplicableIndividualAssessmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
      .builder()
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(sourceEngineName.map(value => value: java.lang.String))(
        _.sourceEngineName
      )
      .optionallyWith(targetEngineName.map(value => value: java.lang.String))(
        _.targetEngineName
      )
      .optionallyWith(migrationType.map(value => value.unwrap))(_.migrationType)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicableIndividualAssessmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest =
      zio.aws.databasemigration.model
        .DescribeApplicableIndividualAssessmentsRequest(
          replicationTaskArn.map(value => value),
          replicationInstanceArn.map(value => value),
          sourceEngineName.map(value => value),
          targetEngineName.map(value => value),
          migrationType.map(value => value),
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def replicationTaskArn: Option[String]
    def replicationInstanceArn: Option[String]
    def sourceEngineName: Option[String]
    def targetEngineName: Option[String]
    def migrationType
        : Option[zio.aws.databasemigration.model.MigrationTypeValue]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getSourceEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceEngineName", sourceEngineName)
    def getTargetEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEngineName", targetEngineName)
    def getMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("migrationType", migrationType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ) extends zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.ReadOnly {
    override val replicationTaskArn: Option[String] =
      scala.Option(impl.replicationTaskArn()).map(value => value: String)
    override val replicationInstanceArn: Option[String] =
      scala.Option(impl.replicationInstanceArn()).map(value => value: String)
    override val sourceEngineName: Option[String] =
      scala.Option(impl.sourceEngineName()).map(value => value: String)
    override val targetEngineName: Option[String] =
      scala.Option(impl.targetEngineName()).map(value => value: String)
    override val migrationType
        : Option[zio.aws.databasemigration.model.MigrationTypeValue] = scala
      .Option(impl.migrationType())
      .map(value =>
        zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
      )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ): zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.ReadOnly =
    new Wrapper(impl)
}
