package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RefreshSchemasRequest(
    endpointArn: String,
    replicationInstanceArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest = {
    import RefreshSchemasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RefreshSchemasRequest.ReadOnly =
    zio.aws.databasemigration.model.RefreshSchemasRequest.wrap(buildAwsValue())
}
object RefreshSchemasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RefreshSchemasRequest =
      zio.aws.databasemigration.model
        .RefreshSchemasRequest(endpointArn, replicationInstanceArn)
    def endpointArn: String
    def replicationInstanceArn: String
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest
  ) extends zio.aws.databasemigration.model.RefreshSchemasRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest
  ): zio.aws.databasemigration.model.RefreshSchemasRequest.ReadOnly =
    new Wrapper(impl)
}
