package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import scala.jdk.CollectionConverters._
final case class PostgreSQLSettings(
    afterConnectScript: Option[String] = None,
    captureDdls: Option[BooleanOptional] = None,
    maxFileSize: Option[IntegerOptional] = None,
    databaseName: Option[String] = None,
    ddlArtifactsSchema: Option[String] = None,
    executeTimeout: Option[IntegerOptional] = None,
    failTasksOnLobTruncation: Option[BooleanOptional] = None,
    heartbeatEnable: Option[BooleanOptional] = None,
    heartbeatSchema: Option[String] = None,
    heartbeatFrequency: Option[IntegerOptional] = None,
    password: Option[SecretString] = None,
    port: Option[IntegerOptional] = None,
    serverName: Option[String] = None,
    username: Option[String] = None,
    slotName: Option[String] = None,
    pluginName: Option[zio.aws.databasemigration.model.PluginNameValue] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings = {
    import PostgreSQLSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
      .builder()
      .optionallyWith(afterConnectScript.map(value => value: java.lang.String))(
        _.afterConnectScript
      )
      .optionallyWith(captureDdls.map(value => value: java.lang.Boolean))(
        _.captureDdls
      )
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(ddlArtifactsSchema.map(value => value: java.lang.String))(
        _.ddlArtifactsSchema
      )
      .optionallyWith(executeTimeout.map(value => value: Integer))(
        _.executeTimeout
      )
      .optionallyWith(
        failTasksOnLobTruncation.map(value => value: java.lang.Boolean)
      )(_.failTasksOnLobTruncation)
      .optionallyWith(heartbeatEnable.map(value => value: java.lang.Boolean))(
        _.heartbeatEnable
      )
      .optionallyWith(heartbeatSchema.map(value => value: java.lang.String))(
        _.heartbeatSchema
      )
      .optionallyWith(heartbeatFrequency.map(value => value: Integer))(
        _.heartbeatFrequency
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(slotName.map(value => value: java.lang.String))(
        _.slotName
      )
      .optionallyWith(pluginName.map(value => value.unwrap))(_.pluginName)
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly =
    zio.aws.databasemigration.model.PostgreSQLSettings.wrap(buildAwsValue())
}
object PostgreSQLSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.PostgreSQLSettings =
      zio.aws.databasemigration.model.PostgreSQLSettings(
        afterConnectScript.map(value => value),
        captureDdls.map(value => value),
        maxFileSize.map(value => value),
        databaseName.map(value => value),
        ddlArtifactsSchema.map(value => value),
        executeTimeout.map(value => value),
        failTasksOnLobTruncation.map(value => value),
        heartbeatEnable.map(value => value),
        heartbeatSchema.map(value => value),
        heartbeatFrequency.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        username.map(value => value),
        slotName.map(value => value),
        pluginName.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def afterConnectScript: Option[String]
    def captureDdls: Option[BooleanOptional]
    def maxFileSize: Option[IntegerOptional]
    def databaseName: Option[String]
    def ddlArtifactsSchema: Option[String]
    def executeTimeout: Option[IntegerOptional]
    def failTasksOnLobTruncation: Option[BooleanOptional]
    def heartbeatEnable: Option[BooleanOptional]
    def heartbeatSchema: Option[String]
    def heartbeatFrequency: Option[IntegerOptional]
    def password: Option[SecretString]
    def port: Option[IntegerOptional]
    def serverName: Option[String]
    def username: Option[String]
    def slotName: Option[String]
    def pluginName: Option[zio.aws.databasemigration.model.PluginNameValue]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getAfterConnectScript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("afterConnectScript", afterConnectScript)
    def getCaptureDdls: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("captureDdls", captureDdls)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDdlArtifactsSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ddlArtifactsSchema", ddlArtifactsSchema)
    def getExecuteTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("executeTimeout", executeTimeout)
    def getFailTasksOnLobTruncation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "failTasksOnLobTruncation",
        failTasksOnLobTruncation
      )
    def getHeartbeatEnable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("heartbeatEnable", heartbeatEnable)
    def getHeartbeatSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("heartbeatSchema", heartbeatSchema)
    def getHeartbeatFrequency: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("heartbeatFrequency", heartbeatFrequency)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSlotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotName", slotName)
    def getPluginName
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.PluginNameValue] =
      AwsError.unwrapOptionField("pluginName", pluginName)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
  ) extends zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly {
    override val afterConnectScript: Option[String] =
      scala.Option(impl.afterConnectScript()).map(value => value: String)
    override val captureDdls: Option[BooleanOptional] =
      scala.Option(impl.captureDdls()).map(value => value: BooleanOptional)
    override val maxFileSize: Option[IntegerOptional] =
      scala.Option(impl.maxFileSize()).map(value => value: IntegerOptional)
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val ddlArtifactsSchema: Option[String] =
      scala.Option(impl.ddlArtifactsSchema()).map(value => value: String)
    override val executeTimeout: Option[IntegerOptional] =
      scala.Option(impl.executeTimeout()).map(value => value: IntegerOptional)
    override val failTasksOnLobTruncation: Option[BooleanOptional] = scala
      .Option(impl.failTasksOnLobTruncation())
      .map(value => value: BooleanOptional)
    override val heartbeatEnable: Option[BooleanOptional] =
      scala.Option(impl.heartbeatEnable()).map(value => value: BooleanOptional)
    override val heartbeatSchema: Option[String] =
      scala.Option(impl.heartbeatSchema()).map(value => value: String)
    override val heartbeatFrequency: Option[IntegerOptional] = scala
      .Option(impl.heartbeatFrequency())
      .map(value => value: IntegerOptional)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val slotName: Option[String] =
      scala.Option(impl.slotName()).map(value => value: String)
    override val pluginName
        : Option[zio.aws.databasemigration.model.PluginNameValue] = scala
      .Option(impl.pluginName())
      .map(value => zio.aws.databasemigration.model.PluginNameValue.wrap(value))
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
  ): zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly = new Wrapper(
    impl
  )
}
