package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeOrderableReplicationInstancesRequest(
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest = {
    import DescribeOrderableReplicationInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
      .builder()
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
      .wrap(buildAwsValue())
}
object DescribeOrderableReplicationInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest =
      zio.aws.databasemigration.model
        .DescribeOrderableReplicationInstancesRequest(
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ) extends zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest.ReadOnly {
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ): zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
