package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.{BooleanOptional, TStamp}
import scala.jdk.CollectionConverters._
final case class TableStatistics(
    schemaName: Option[String] = None,
    tableName: Option[String] = None,
    inserts: Option[Long] = None,
    deletes: Option[Long] = None,
    updates: Option[Long] = None,
    ddls: Option[Long] = None,
    fullLoadRows: Option[Long] = None,
    fullLoadCondtnlChkFailedRows: Option[Long] = None,
    fullLoadErrorRows: Option[Long] = None,
    fullLoadStartTime: Option[TStamp] = None,
    fullLoadEndTime: Option[TStamp] = None,
    fullLoadReloaded: Option[BooleanOptional] = None,
    lastUpdateTime: Option[TStamp] = None,
    tableState: Option[String] = None,
    validationPendingRecords: Option[Long] = None,
    validationFailedRecords: Option[Long] = None,
    validationSuspendedRecords: Option[Long] = None,
    validationState: Option[String] = None,
    validationStateDetails: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.TableStatistics = {
    import TableStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.TableStatistics
      .builder()
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .optionallyWith(inserts.map(value => value: java.lang.Long))(_.inserts)
      .optionallyWith(deletes.map(value => value: java.lang.Long))(_.deletes)
      .optionallyWith(updates.map(value => value: java.lang.Long))(_.updates)
      .optionallyWith(ddls.map(value => value: java.lang.Long))(_.ddls)
      .optionallyWith(fullLoadRows.map(value => value: java.lang.Long))(
        _.fullLoadRows
      )
      .optionallyWith(
        fullLoadCondtnlChkFailedRows.map(value => value: java.lang.Long)
      )(_.fullLoadCondtnlChkFailedRows)
      .optionallyWith(fullLoadErrorRows.map(value => value: java.lang.Long))(
        _.fullLoadErrorRows
      )
      .optionallyWith(
        fullLoadStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadStartTime)
      .optionallyWith(
        fullLoadEndTime.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadEndTime)
      .optionallyWith(fullLoadReloaded.map(value => value: java.lang.Boolean))(
        _.fullLoadReloaded
      )
      .optionallyWith(
        lastUpdateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(tableState.map(value => value: java.lang.String))(
        _.tableState
      )
      .optionallyWith(
        validationPendingRecords.map(value => value: java.lang.Long)
      )(_.validationPendingRecords)
      .optionallyWith(
        validationFailedRecords.map(value => value: java.lang.Long)
      )(_.validationFailedRecords)
      .optionallyWith(
        validationSuspendedRecords.map(value => value: java.lang.Long)
      )(_.validationSuspendedRecords)
      .optionallyWith(validationState.map(value => value: java.lang.String))(
        _.validationState
      )
      .optionallyWith(
        validationStateDetails.map(value => value: java.lang.String)
      )(_.validationStateDetails)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.TableStatistics.ReadOnly =
    zio.aws.databasemigration.model.TableStatistics.wrap(buildAwsValue())
}
object TableStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.TableStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.TableStatistics =
      zio.aws.databasemigration.model.TableStatistics(
        schemaName.map(value => value),
        tableName.map(value => value),
        inserts.map(value => value),
        deletes.map(value => value),
        updates.map(value => value),
        ddls.map(value => value),
        fullLoadRows.map(value => value),
        fullLoadCondtnlChkFailedRows.map(value => value),
        fullLoadErrorRows.map(value => value),
        fullLoadStartTime.map(value => value),
        fullLoadEndTime.map(value => value),
        fullLoadReloaded.map(value => value),
        lastUpdateTime.map(value => value),
        tableState.map(value => value),
        validationPendingRecords.map(value => value),
        validationFailedRecords.map(value => value),
        validationSuspendedRecords.map(value => value),
        validationState.map(value => value),
        validationStateDetails.map(value => value)
      )
    def schemaName: Option[String]
    def tableName: Option[String]
    def inserts: Option[Long]
    def deletes: Option[Long]
    def updates: Option[Long]
    def ddls: Option[Long]
    def fullLoadRows: Option[Long]
    def fullLoadCondtnlChkFailedRows: Option[Long]
    def fullLoadErrorRows: Option[Long]
    def fullLoadStartTime: Option[TStamp]
    def fullLoadEndTime: Option[TStamp]
    def fullLoadReloaded: Option[BooleanOptional]
    def lastUpdateTime: Option[TStamp]
    def tableState: Option[String]
    def validationPendingRecords: Option[Long]
    def validationFailedRecords: Option[Long]
    def validationSuspendedRecords: Option[Long]
    def validationState: Option[String]
    def validationStateDetails: Option[String]
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getInserts: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("inserts", inserts)
    def getDeletes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deletes", deletes)
    def getUpdates: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("updates", updates)
    def getDdls: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("ddls", ddls)
    def getFullLoadRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fullLoadRows", fullLoadRows)
    def getFullLoadCondtnlChkFailedRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "fullLoadCondtnlChkFailedRows",
        fullLoadCondtnlChkFailedRows
      )
    def getFullLoadErrorRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fullLoadErrorRows", fullLoadErrorRows)
    def getFullLoadStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadStartTime", fullLoadStartTime)
    def getFullLoadEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadEndTime", fullLoadEndTime)
    def getFullLoadReloaded: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("fullLoadReloaded", fullLoadReloaded)
    def getLastUpdateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getTableState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableState", tableState)
    def getValidationPendingRecords: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("validationPendingRecords", validationPendingRecords)
    def getValidationFailedRecords: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("validationFailedRecords", validationFailedRecords)
    def getValidationSuspendedRecords: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "validationSuspendedRecords",
        validationSuspendedRecords
      )
    def getValidationState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("validationState", validationState)
    def getValidationStateDetails: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("validationStateDetails", validationStateDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.TableStatistics
  ) extends zio.aws.databasemigration.model.TableStatistics.ReadOnly {
    override val schemaName: Option[String] =
      scala.Option(impl.schemaName()).map(value => value: String)
    override val tableName: Option[String] =
      scala.Option(impl.tableName()).map(value => value: String)
    override val inserts: Option[Long] =
      scala.Option(impl.inserts()).map(value => value: Long)
    override val deletes: Option[Long] =
      scala.Option(impl.deletes()).map(value => value: Long)
    override val updates: Option[Long] =
      scala.Option(impl.updates()).map(value => value: Long)
    override val ddls: Option[Long] =
      scala.Option(impl.ddls()).map(value => value: Long)
    override val fullLoadRows: Option[Long] =
      scala.Option(impl.fullLoadRows()).map(value => value: Long)
    override val fullLoadCondtnlChkFailedRows: Option[Long] = scala
      .Option(impl.fullLoadCondtnlChkFailedRows())
      .map(value => value: Long)
    override val fullLoadErrorRows: Option[Long] =
      scala.Option(impl.fullLoadErrorRows()).map(value => value: Long)
    override val fullLoadStartTime: Option[TStamp] = scala
      .Option(impl.fullLoadStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadEndTime: Option[TStamp] = scala
      .Option(impl.fullLoadEndTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadReloaded: Option[BooleanOptional] =
      scala.Option(impl.fullLoadReloaded()).map(value => value: BooleanOptional)
    override val lastUpdateTime: Option[TStamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val tableState: Option[String] =
      scala.Option(impl.tableState()).map(value => value: String)
    override val validationPendingRecords: Option[Long] =
      scala.Option(impl.validationPendingRecords()).map(value => value: Long)
    override val validationFailedRecords: Option[Long] =
      scala.Option(impl.validationFailedRecords()).map(value => value: Long)
    override val validationSuspendedRecords: Option[Long] =
      scala.Option(impl.validationSuspendedRecords()).map(value => value: Long)
    override val validationState: Option[String] =
      scala.Option(impl.validationState()).map(value => value: String)
    override val validationStateDetails: Option[String] =
      scala.Option(impl.validationStateDetails()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.TableStatistics
  ): zio.aws.databasemigration.model.TableStatistics.ReadOnly = new Wrapper(
    impl
  )
}
