package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import scala.jdk.CollectionConverters._
final case class MySQLSettings(
    afterConnectScript: Option[String] = None,
    cleanSourceMetadataOnMismatch: Option[BooleanOptional] = None,
    databaseName: Option[String] = None,
    eventsPollInterval: Option[IntegerOptional] = None,
    targetDbType: Option[zio.aws.databasemigration.model.TargetDbType] = None,
    maxFileSize: Option[IntegerOptional] = None,
    parallelLoadThreads: Option[IntegerOptional] = None,
    password: Option[SecretString] = None,
    port: Option[IntegerOptional] = None,
    serverName: Option[String] = None,
    serverTimezone: Option[String] = None,
    username: Option[String] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MySQLSettings = {
    import MySQLSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MySQLSettings
      .builder()
      .optionallyWith(afterConnectScript.map(value => value: java.lang.String))(
        _.afterConnectScript
      )
      .optionallyWith(
        cleanSourceMetadataOnMismatch.map(value => value: java.lang.Boolean)
      )(_.cleanSourceMetadataOnMismatch)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(eventsPollInterval.map(value => value: Integer))(
        _.eventsPollInterval
      )
      .optionallyWith(targetDbType.map(value => value.unwrap))(_.targetDbType)
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(parallelLoadThreads.map(value => value: Integer))(
        _.parallelLoadThreads
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(serverTimezone.map(value => value: java.lang.String))(
        _.serverTimezone
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.MySQLSettings.ReadOnly =
    zio.aws.databasemigration.model.MySQLSettings.wrap(buildAwsValue())
}
object MySQLSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MySQLSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MySQLSettings =
      zio.aws.databasemigration.model.MySQLSettings(
        afterConnectScript.map(value => value),
        cleanSourceMetadataOnMismatch.map(value => value),
        databaseName.map(value => value),
        eventsPollInterval.map(value => value),
        targetDbType.map(value => value),
        maxFileSize.map(value => value),
        parallelLoadThreads.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        serverTimezone.map(value => value),
        username.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def afterConnectScript: Option[String]
    def cleanSourceMetadataOnMismatch: Option[BooleanOptional]
    def databaseName: Option[String]
    def eventsPollInterval: Option[IntegerOptional]
    def targetDbType: Option[zio.aws.databasemigration.model.TargetDbType]
    def maxFileSize: Option[IntegerOptional]
    def parallelLoadThreads: Option[IntegerOptional]
    def password: Option[SecretString]
    def port: Option[IntegerOptional]
    def serverName: Option[String]
    def serverTimezone: Option[String]
    def username: Option[String]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getAfterConnectScript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("afterConnectScript", afterConnectScript)
    def getCleanSourceMetadataOnMismatch: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "cleanSourceMetadataOnMismatch",
        cleanSourceMetadataOnMismatch
      )
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getEventsPollInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("eventsPollInterval", eventsPollInterval)
    def getTargetDbType
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.TargetDbType] =
      AwsError.unwrapOptionField("targetDbType", targetDbType)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getParallelLoadThreads: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("parallelLoadThreads", parallelLoadThreads)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getServerTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverTimezone", serverTimezone)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MySQLSettings
  ) extends zio.aws.databasemigration.model.MySQLSettings.ReadOnly {
    override val afterConnectScript: Option[String] =
      scala.Option(impl.afterConnectScript()).map(value => value: String)
    override val cleanSourceMetadataOnMismatch: Option[BooleanOptional] = scala
      .Option(impl.cleanSourceMetadataOnMismatch())
      .map(value => value: BooleanOptional)
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val eventsPollInterval: Option[IntegerOptional] = scala
      .Option(impl.eventsPollInterval())
      .map(value => value: IntegerOptional)
    override val targetDbType
        : Option[zio.aws.databasemigration.model.TargetDbType] = scala
      .Option(impl.targetDbType())
      .map(value => zio.aws.databasemigration.model.TargetDbType.wrap(value))
    override val maxFileSize: Option[IntegerOptional] =
      scala.Option(impl.maxFileSize()).map(value => value: IntegerOptional)
    override val parallelLoadThreads: Option[IntegerOptional] = scala
      .Option(impl.parallelLoadThreads())
      .map(value => value: IntegerOptional)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val serverTimezone: Option[String] =
      scala.Option(impl.serverTimezone()).map(value => value: String)
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MySQLSettings
  ): zio.aws.databasemigration.model.MySQLSettings.ReadOnly = new Wrapper(impl)
}
