package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeEndpointsRequest(
    filters: Option[Iterable[zio.aws.databasemigration.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest = {
    import DescribeEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEndpointsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeEndpointsRequest
      .wrap(buildAwsValue())
}
object DescribeEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DescribeEndpointsRequest =
      zio.aws.databasemigration.model.DescribeEndpointsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def filters: Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest
  ) extends zio.aws.databasemigration.model.DescribeEndpointsRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest
  ): zio.aws.databasemigration.model.DescribeEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
