package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class S3Settings(
    serviceAccessRoleArn: Option[String] = None,
    externalTableDefinition: Option[String] = None,
    csvRowDelimiter: Option[String] = None,
    csvDelimiter: Option[String] = None,
    bucketFolder: Option[String] = None,
    bucketName: Option[String] = None,
    compressionType: Option[
      zio.aws.databasemigration.model.CompressionTypeValue
    ] = None,
    encryptionMode: Option[
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = None,
    serverSideEncryptionKmsKeyId: Option[String] = None,
    dataFormat: Option[zio.aws.databasemigration.model.DataFormatValue] = None,
    encodingType: Option[zio.aws.databasemigration.model.EncodingTypeValue] =
      None,
    dictPageSizeLimit: Option[IntegerOptional] = None,
    rowGroupLength: Option[IntegerOptional] = None,
    dataPageSize: Option[IntegerOptional] = None,
    parquetVersion: Option[
      zio.aws.databasemigration.model.ParquetVersionValue
    ] = None,
    enableStatistics: Option[BooleanOptional] = None,
    includeOpForFullLoad: Option[BooleanOptional] = None,
    cdcInsertsOnly: Option[BooleanOptional] = None,
    timestampColumnName: Option[String] = None,
    parquetTimestampInMillisecond: Option[BooleanOptional] = None,
    cdcInsertsAndUpdates: Option[BooleanOptional] = None,
    datePartitionEnabled: Option[BooleanOptional] = None,
    datePartitionSequence: Option[
      zio.aws.databasemigration.model.DatePartitionSequenceValue
    ] = None,
    datePartitionDelimiter: Option[
      zio.aws.databasemigration.model.DatePartitionDelimiterValue
    ] = None,
    useCsvNoSupValue: Option[BooleanOptional] = None,
    csvNoSupValue: Option[String] = None,
    preserveTransactions: Option[BooleanOptional] = None,
    cdcPath: Option[String] = None,
    useTaskStartTimeForFullLoadTimestamp: Option[BooleanOptional] = None,
    cannedAclForObjects: Option[
      zio.aws.databasemigration.model.CannedAclForObjectsValue
    ] = None,
    addColumnName: Option[BooleanOptional] = None,
    cdcMaxBatchInterval: Option[IntegerOptional] = None,
    cdcMinFileSize: Option[IntegerOptional] = None,
    csvNullValue: Option[String] = None,
    ignoreHeaderRows: Option[IntegerOptional] = None,
    maxFileSize: Option[IntegerOptional] = None,
    rfc4180: Option[BooleanOptional] = None,
    datePartitionTimezone: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.S3Settings = {
    import S3Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.S3Settings
      .builder()
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        externalTableDefinition.map(value => value: java.lang.String)
      )(_.externalTableDefinition)
      .optionallyWith(csvRowDelimiter.map(value => value: java.lang.String))(
        _.csvRowDelimiter
      )
      .optionallyWith(csvDelimiter.map(value => value: java.lang.String))(
        _.csvDelimiter
      )
      .optionallyWith(bucketFolder.map(value => value: java.lang.String))(
        _.bucketFolder
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .optionallyWith(
        serverSideEncryptionKmsKeyId.map(value => value: java.lang.String)
      )(_.serverSideEncryptionKmsKeyId)
      .optionallyWith(dataFormat.map(value => value.unwrap))(_.dataFormat)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(dictPageSizeLimit.map(value => value: Integer))(
        _.dictPageSizeLimit
      )
      .optionallyWith(rowGroupLength.map(value => value: Integer))(
        _.rowGroupLength
      )
      .optionallyWith(dataPageSize.map(value => value: Integer))(_.dataPageSize)
      .optionallyWith(parquetVersion.map(value => value.unwrap))(
        _.parquetVersion
      )
      .optionallyWith(enableStatistics.map(value => value: java.lang.Boolean))(
        _.enableStatistics
      )
      .optionallyWith(
        includeOpForFullLoad.map(value => value: java.lang.Boolean)
      )(_.includeOpForFullLoad)
      .optionallyWith(cdcInsertsOnly.map(value => value: java.lang.Boolean))(
        _.cdcInsertsOnly
      )
      .optionallyWith(
        timestampColumnName.map(value => value: java.lang.String)
      )(_.timestampColumnName)
      .optionallyWith(
        parquetTimestampInMillisecond.map(value => value: java.lang.Boolean)
      )(_.parquetTimestampInMillisecond)
      .optionallyWith(
        cdcInsertsAndUpdates.map(value => value: java.lang.Boolean)
      )(_.cdcInsertsAndUpdates)
      .optionallyWith(
        datePartitionEnabled.map(value => value: java.lang.Boolean)
      )(_.datePartitionEnabled)
      .optionallyWith(datePartitionSequence.map(value => value.unwrap))(
        _.datePartitionSequence
      )
      .optionallyWith(datePartitionDelimiter.map(value => value.unwrap))(
        _.datePartitionDelimiter
      )
      .optionallyWith(useCsvNoSupValue.map(value => value: java.lang.Boolean))(
        _.useCsvNoSupValue
      )
      .optionallyWith(csvNoSupValue.map(value => value: java.lang.String))(
        _.csvNoSupValue
      )
      .optionallyWith(
        preserveTransactions.map(value => value: java.lang.Boolean)
      )(_.preserveTransactions)
      .optionallyWith(cdcPath.map(value => value: java.lang.String))(_.cdcPath)
      .optionallyWith(
        useTaskStartTimeForFullLoadTimestamp.map(value =>
          value: java.lang.Boolean
        )
      )(_.useTaskStartTimeForFullLoadTimestamp)
      .optionallyWith(cannedAclForObjects.map(value => value.unwrap))(
        _.cannedAclForObjects
      )
      .optionallyWith(addColumnName.map(value => value: java.lang.Boolean))(
        _.addColumnName
      )
      .optionallyWith(cdcMaxBatchInterval.map(value => value: Integer))(
        _.cdcMaxBatchInterval
      )
      .optionallyWith(cdcMinFileSize.map(value => value: Integer))(
        _.cdcMinFileSize
      )
      .optionallyWith(csvNullValue.map(value => value: java.lang.String))(
        _.csvNullValue
      )
      .optionallyWith(ignoreHeaderRows.map(value => value: Integer))(
        _.ignoreHeaderRows
      )
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(rfc4180.map(value => value: java.lang.Boolean))(_.rfc4180)
      .optionallyWith(
        datePartitionTimezone.map(value => value: java.lang.String)
      )(_.datePartitionTimezone)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.S3Settings.ReadOnly =
    zio.aws.databasemigration.model.S3Settings.wrap(buildAwsValue())
}
object S3Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.S3Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.S3Settings =
      zio.aws.databasemigration.model.S3Settings(
        serviceAccessRoleArn.map(value => value),
        externalTableDefinition.map(value => value),
        csvRowDelimiter.map(value => value),
        csvDelimiter.map(value => value),
        bucketFolder.map(value => value),
        bucketName.map(value => value),
        compressionType.map(value => value),
        encryptionMode.map(value => value),
        serverSideEncryptionKmsKeyId.map(value => value),
        dataFormat.map(value => value),
        encodingType.map(value => value),
        dictPageSizeLimit.map(value => value),
        rowGroupLength.map(value => value),
        dataPageSize.map(value => value),
        parquetVersion.map(value => value),
        enableStatistics.map(value => value),
        includeOpForFullLoad.map(value => value),
        cdcInsertsOnly.map(value => value),
        timestampColumnName.map(value => value),
        parquetTimestampInMillisecond.map(value => value),
        cdcInsertsAndUpdates.map(value => value),
        datePartitionEnabled.map(value => value),
        datePartitionSequence.map(value => value),
        datePartitionDelimiter.map(value => value),
        useCsvNoSupValue.map(value => value),
        csvNoSupValue.map(value => value),
        preserveTransactions.map(value => value),
        cdcPath.map(value => value),
        useTaskStartTimeForFullLoadTimestamp.map(value => value),
        cannedAclForObjects.map(value => value),
        addColumnName.map(value => value),
        cdcMaxBatchInterval.map(value => value),
        cdcMinFileSize.map(value => value),
        csvNullValue.map(value => value),
        ignoreHeaderRows.map(value => value),
        maxFileSize.map(value => value),
        rfc4180.map(value => value),
        datePartitionTimezone.map(value => value)
      )
    def serviceAccessRoleArn: Option[String]
    def externalTableDefinition: Option[String]
    def csvRowDelimiter: Option[String]
    def csvDelimiter: Option[String]
    def bucketFolder: Option[String]
    def bucketName: Option[String]
    def compressionType
        : Option[zio.aws.databasemigration.model.CompressionTypeValue]
    def encryptionMode
        : Option[zio.aws.databasemigration.model.EncryptionModeValue]
    def serverSideEncryptionKmsKeyId: Option[String]
    def dataFormat: Option[zio.aws.databasemigration.model.DataFormatValue]
    def encodingType: Option[zio.aws.databasemigration.model.EncodingTypeValue]
    def dictPageSizeLimit: Option[IntegerOptional]
    def rowGroupLength: Option[IntegerOptional]
    def dataPageSize: Option[IntegerOptional]
    def parquetVersion
        : Option[zio.aws.databasemigration.model.ParquetVersionValue]
    def enableStatistics: Option[BooleanOptional]
    def includeOpForFullLoad: Option[BooleanOptional]
    def cdcInsertsOnly: Option[BooleanOptional]
    def timestampColumnName: Option[String]
    def parquetTimestampInMillisecond: Option[BooleanOptional]
    def cdcInsertsAndUpdates: Option[BooleanOptional]
    def datePartitionEnabled: Option[BooleanOptional]
    def datePartitionSequence
        : Option[zio.aws.databasemigration.model.DatePartitionSequenceValue]
    def datePartitionDelimiter
        : Option[zio.aws.databasemigration.model.DatePartitionDelimiterValue]
    def useCsvNoSupValue: Option[BooleanOptional]
    def csvNoSupValue: Option[String]
    def preserveTransactions: Option[BooleanOptional]
    def cdcPath: Option[String]
    def useTaskStartTimeForFullLoadTimestamp: Option[BooleanOptional]
    def cannedAclForObjects
        : Option[zio.aws.databasemigration.model.CannedAclForObjectsValue]
    def addColumnName: Option[BooleanOptional]
    def cdcMaxBatchInterval: Option[IntegerOptional]
    def cdcMinFileSize: Option[IntegerOptional]
    def csvNullValue: Option[String]
    def ignoreHeaderRows: Option[IntegerOptional]
    def maxFileSize: Option[IntegerOptional]
    def rfc4180: Option[BooleanOptional]
    def datePartitionTimezone: Option[String]
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getExternalTableDefinition: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("externalTableDefinition", externalTableDefinition)
    def getCsvRowDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvRowDelimiter", csvRowDelimiter)
    def getCsvDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvDelimiter", csvDelimiter)
    def getBucketFolder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketFolder", bucketFolder)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getCompressionType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CompressionTypeValue
    ] = AwsError.unwrapOptionField("compressionType", compressionType)
    def getEncryptionMode: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getServerSideEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "serverSideEncryptionKmsKeyId",
        serverSideEncryptionKmsKeyId
      )
    def getDataFormat
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DataFormatValue] =
      AwsError.unwrapOptionField("dataFormat", dataFormat)
    def getEncodingType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EncodingTypeValue
    ] = AwsError.unwrapOptionField("encodingType", encodingType)
    def getDictPageSizeLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("dictPageSizeLimit", dictPageSizeLimit)
    def getRowGroupLength: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("rowGroupLength", rowGroupLength)
    def getDataPageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("dataPageSize", dataPageSize)
    def getParquetVersion: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ParquetVersionValue
    ] = AwsError.unwrapOptionField("parquetVersion", parquetVersion)
    def getEnableStatistics: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableStatistics", enableStatistics)
    def getIncludeOpForFullLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeOpForFullLoad", includeOpForFullLoad)
    def getCdcInsertsOnly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("cdcInsertsOnly", cdcInsertsOnly)
    def getTimestampColumnName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timestampColumnName", timestampColumnName)
    def getParquetTimestampInMillisecond: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "parquetTimestampInMillisecond",
        parquetTimestampInMillisecond
      )
    def getCdcInsertsAndUpdates: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("cdcInsertsAndUpdates", cdcInsertsAndUpdates)
    def getDatePartitionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("datePartitionEnabled", datePartitionEnabled)
    def getDatePartitionSequence: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatePartitionSequenceValue
    ] =
      AwsError.unwrapOptionField("datePartitionSequence", datePartitionSequence)
    def getDatePartitionDelimiter: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatePartitionDelimiterValue
    ] = AwsError.unwrapOptionField(
      "datePartitionDelimiter",
      datePartitionDelimiter
    )
    def getUseCsvNoSupValue: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useCsvNoSupValue", useCsvNoSupValue)
    def getCsvNoSupValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvNoSupValue", csvNoSupValue)
    def getPreserveTransactions: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("preserveTransactions", preserveTransactions)
    def getCdcPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcPath", cdcPath)
    def getUseTaskStartTimeForFullLoadTimestamp
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "useTaskStartTimeForFullLoadTimestamp",
      useTaskStartTimeForFullLoadTimestamp
    )
    def getCannedAclForObjects: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CannedAclForObjectsValue
    ] = AwsError.unwrapOptionField("cannedAclForObjects", cannedAclForObjects)
    def getAddColumnName: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("addColumnName", addColumnName)
    def getCdcMaxBatchInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("cdcMaxBatchInterval", cdcMaxBatchInterval)
    def getCdcMinFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("cdcMinFileSize", cdcMinFileSize)
    def getCsvNullValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvNullValue", csvNullValue)
    def getIgnoreHeaderRows: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("ignoreHeaderRows", ignoreHeaderRows)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getRfc4180: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("rfc4180", rfc4180)
    def getDatePartitionTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("datePartitionTimezone", datePartitionTimezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.S3Settings
  ) extends zio.aws.databasemigration.model.S3Settings.ReadOnly {
    override val serviceAccessRoleArn: Option[String] =
      scala.Option(impl.serviceAccessRoleArn()).map(value => value: String)
    override val externalTableDefinition: Option[String] =
      scala.Option(impl.externalTableDefinition()).map(value => value: String)
    override val csvRowDelimiter: Option[String] =
      scala.Option(impl.csvRowDelimiter()).map(value => value: String)
    override val csvDelimiter: Option[String] =
      scala.Option(impl.csvDelimiter()).map(value => value: String)
    override val bucketFolder: Option[String] =
      scala.Option(impl.bucketFolder()).map(value => value: String)
    override val bucketName: Option[String] =
      scala.Option(impl.bucketName()).map(value => value: String)
    override val compressionType
        : Option[zio.aws.databasemigration.model.CompressionTypeValue] = scala
      .Option(impl.compressionType())
      .map(value =>
        zio.aws.databasemigration.model.CompressionTypeValue.wrap(value)
      )
    override val encryptionMode
        : Option[zio.aws.databasemigration.model.EncryptionModeValue] = scala
      .Option(impl.encryptionMode())
      .map(value =>
        zio.aws.databasemigration.model.EncryptionModeValue.wrap(value)
      )
    override val serverSideEncryptionKmsKeyId: Option[String] = scala
      .Option(impl.serverSideEncryptionKmsKeyId())
      .map(value => value: String)
    override val dataFormat
        : Option[zio.aws.databasemigration.model.DataFormatValue] = scala
      .Option(impl.dataFormat())
      .map(value => zio.aws.databasemigration.model.DataFormatValue.wrap(value))
    override val encodingType
        : Option[zio.aws.databasemigration.model.EncodingTypeValue] = scala
      .Option(impl.encodingType())
      .map(value =>
        zio.aws.databasemigration.model.EncodingTypeValue.wrap(value)
      )
    override val dictPageSizeLimit: Option[IntegerOptional] = scala
      .Option(impl.dictPageSizeLimit())
      .map(value => value: IntegerOptional)
    override val rowGroupLength: Option[IntegerOptional] =
      scala.Option(impl.rowGroupLength()).map(value => value: IntegerOptional)
    override val dataPageSize: Option[IntegerOptional] =
      scala.Option(impl.dataPageSize()).map(value => value: IntegerOptional)
    override val parquetVersion
        : Option[zio.aws.databasemigration.model.ParquetVersionValue] = scala
      .Option(impl.parquetVersion())
      .map(value =>
        zio.aws.databasemigration.model.ParquetVersionValue.wrap(value)
      )
    override val enableStatistics: Option[BooleanOptional] =
      scala.Option(impl.enableStatistics()).map(value => value: BooleanOptional)
    override val includeOpForFullLoad: Option[BooleanOptional] = scala
      .Option(impl.includeOpForFullLoad())
      .map(value => value: BooleanOptional)
    override val cdcInsertsOnly: Option[BooleanOptional] =
      scala.Option(impl.cdcInsertsOnly()).map(value => value: BooleanOptional)
    override val timestampColumnName: Option[String] =
      scala.Option(impl.timestampColumnName()).map(value => value: String)
    override val parquetTimestampInMillisecond: Option[BooleanOptional] = scala
      .Option(impl.parquetTimestampInMillisecond())
      .map(value => value: BooleanOptional)
    override val cdcInsertsAndUpdates: Option[BooleanOptional] = scala
      .Option(impl.cdcInsertsAndUpdates())
      .map(value => value: BooleanOptional)
    override val datePartitionEnabled: Option[BooleanOptional] = scala
      .Option(impl.datePartitionEnabled())
      .map(value => value: BooleanOptional)
    override val datePartitionSequence
        : Option[zio.aws.databasemigration.model.DatePartitionSequenceValue] =
      scala
        .Option(impl.datePartitionSequence())
        .map(value =>
          zio.aws.databasemigration.model.DatePartitionSequenceValue.wrap(value)
        )
    override val datePartitionDelimiter
        : Option[zio.aws.databasemigration.model.DatePartitionDelimiterValue] =
      scala
        .Option(impl.datePartitionDelimiter())
        .map(value =>
          zio.aws.databasemigration.model.DatePartitionDelimiterValue
            .wrap(value)
        )
    override val useCsvNoSupValue: Option[BooleanOptional] =
      scala.Option(impl.useCsvNoSupValue()).map(value => value: BooleanOptional)
    override val csvNoSupValue: Option[String] =
      scala.Option(impl.csvNoSupValue()).map(value => value: String)
    override val preserveTransactions: Option[BooleanOptional] = scala
      .Option(impl.preserveTransactions())
      .map(value => value: BooleanOptional)
    override val cdcPath: Option[String] =
      scala.Option(impl.cdcPath()).map(value => value: String)
    override val useTaskStartTimeForFullLoadTimestamp: Option[BooleanOptional] =
      scala
        .Option(impl.useTaskStartTimeForFullLoadTimestamp())
        .map(value => value: BooleanOptional)
    override val cannedAclForObjects
        : Option[zio.aws.databasemigration.model.CannedAclForObjectsValue] =
      scala
        .Option(impl.cannedAclForObjects())
        .map(value =>
          zio.aws.databasemigration.model.CannedAclForObjectsValue.wrap(value)
        )
    override val addColumnName: Option[BooleanOptional] =
      scala.Option(impl.addColumnName()).map(value => value: BooleanOptional)
    override val cdcMaxBatchInterval: Option[IntegerOptional] = scala
      .Option(impl.cdcMaxBatchInterval())
      .map(value => value: IntegerOptional)
    override val cdcMinFileSize: Option[IntegerOptional] =
      scala.Option(impl.cdcMinFileSize()).map(value => value: IntegerOptional)
    override val csvNullValue: Option[String] =
      scala.Option(impl.csvNullValue()).map(value => value: String)
    override val ignoreHeaderRows: Option[IntegerOptional] =
      scala.Option(impl.ignoreHeaderRows()).map(value => value: IntegerOptional)
    override val maxFileSize: Option[IntegerOptional] =
      scala.Option(impl.maxFileSize()).map(value => value: IntegerOptional)
    override val rfc4180: Option[BooleanOptional] =
      scala.Option(impl.rfc4180()).map(value => value: BooleanOptional)
    override val datePartitionTimezone: Option[String] =
      scala.Option(impl.datePartitionTimezone()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.S3Settings
  ): zio.aws.databasemigration.model.S3Settings.ReadOnly = new Wrapper(impl)
}
