package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class ReplicationPendingModifiedValues(
    replicationInstanceClass: Option[String] = None,
    allocatedStorage: Option[IntegerOptional] = None,
    multiAZ: Option[BooleanOptional] = None,
    engineVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues = {
    import ReplicationPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
      .builder()
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly =
    zio.aws.databasemigration.model.ReplicationPendingModifiedValues
      .wrap(buildAwsValue())
}
object ReplicationPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationPendingModifiedValues =
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues(
        replicationInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value)
      )
    def replicationInstanceClass: Option[String]
    def allocatedStorage: Option[IntegerOptional]
    def multiAZ: Option[BooleanOptional]
    def engineVersion: Option[String]
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
  ) extends zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly {
    override val replicationInstanceClass: Option[String] =
      scala.Option(impl.replicationInstanceClass()).map(value => value: String)
    override val allocatedStorage: Option[IntegerOptional] =
      scala.Option(impl.allocatedStorage()).map(value => value: IntegerOptional)
    override val multiAZ: Option[BooleanOptional] =
      scala.Option(impl.multiAZ()).map(value => value: BooleanOptional)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
  ): zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly =
    new Wrapper(impl)
}
