package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class ReplicationTask(
    replicationTaskIdentifier: Option[String] = None,
    sourceEndpointArn: Option[String] = None,
    targetEndpointArn: Option[String] = None,
    replicationInstanceArn: Option[String] = None,
    migrationType: Option[zio.aws.databasemigration.model.MigrationTypeValue] =
      None,
    tableMappings: Option[String] = None,
    replicationTaskSettings: Option[String] = None,
    status: Option[String] = None,
    lastFailureMessage: Option[String] = None,
    stopReason: Option[String] = None,
    replicationTaskCreationDate: Option[TStamp] = None,
    replicationTaskStartDate: Option[TStamp] = None,
    cdcStartPosition: Option[String] = None,
    cdcStopPosition: Option[String] = None,
    recoveryCheckpoint: Option[String] = None,
    replicationTaskArn: Option[String] = None,
    replicationTaskStats: Option[
      zio.aws.databasemigration.model.ReplicationTaskStats
    ] = None,
    taskData: Option[String] = None,
    targetReplicationInstanceArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTask = {
    import ReplicationTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTask
      .builder()
      .optionallyWith(
        replicationTaskIdentifier.map(value => value: java.lang.String)
      )(_.replicationTaskIdentifier)
      .optionallyWith(sourceEndpointArn.map(value => value: java.lang.String))(
        _.sourceEndpointArn
      )
      .optionallyWith(targetEndpointArn.map(value => value: java.lang.String))(
        _.targetEndpointArn
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(migrationType.map(value => value.unwrap))(_.migrationType)
      .optionallyWith(tableMappings.map(value => value: java.lang.String))(
        _.tableMappings
      )
      .optionallyWith(
        replicationTaskSettings.map(value => value: java.lang.String)
      )(_.replicationTaskSettings)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(stopReason.map(value => value: java.lang.String))(
        _.stopReason
      )
      .optionallyWith(
        replicationTaskCreationDate.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationTaskCreationDate)
      .optionallyWith(
        replicationTaskStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationTaskStartDate)
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .optionallyWith(recoveryCheckpoint.map(value => value: java.lang.String))(
        _.recoveryCheckpoint
      )
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(replicationTaskStats.map(value => value.buildAwsValue()))(
        _.replicationTaskStats
      )
      .optionallyWith(taskData.map(value => value: java.lang.String))(
        _.taskData
      )
      .optionallyWith(
        targetReplicationInstanceArn.map(value => value: java.lang.String)
      )(_.targetReplicationInstanceArn)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ReplicationTask.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTask.wrap(buildAwsValue())
}
object ReplicationTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationTask =
      zio.aws.databasemigration.model.ReplicationTask(
        replicationTaskIdentifier.map(value => value),
        sourceEndpointArn.map(value => value),
        targetEndpointArn.map(value => value),
        replicationInstanceArn.map(value => value),
        migrationType.map(value => value),
        tableMappings.map(value => value),
        replicationTaskSettings.map(value => value),
        status.map(value => value),
        lastFailureMessage.map(value => value),
        stopReason.map(value => value),
        replicationTaskCreationDate.map(value => value),
        replicationTaskStartDate.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value),
        recoveryCheckpoint.map(value => value),
        replicationTaskArn.map(value => value),
        replicationTaskStats.map(value => value.asEditable),
        taskData.map(value => value),
        targetReplicationInstanceArn.map(value => value)
      )
    def replicationTaskIdentifier: Option[String]
    def sourceEndpointArn: Option[String]
    def targetEndpointArn: Option[String]
    def replicationInstanceArn: Option[String]
    def migrationType
        : Option[zio.aws.databasemigration.model.MigrationTypeValue]
    def tableMappings: Option[String]
    def replicationTaskSettings: Option[String]
    def status: Option[String]
    def lastFailureMessage: Option[String]
    def stopReason: Option[String]
    def replicationTaskCreationDate: Option[TStamp]
    def replicationTaskStartDate: Option[TStamp]
    def cdcStartPosition: Option[String]
    def cdcStopPosition: Option[String]
    def recoveryCheckpoint: Option[String]
    def replicationTaskArn: Option[String]
    def replicationTaskStats
        : Option[zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly]
    def taskData: Option[String]
    def targetReplicationInstanceArn: Option[String]
    def getReplicationTaskIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskIdentifier", replicationTaskIdentifier)
    def getSourceEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceEndpointArn", sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEndpointArn", targetEndpointArn)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("migrationType", migrationType)
    def getTableMappings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableMappings", tableMappings)
    def getReplicationTaskSettings: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskSettings", replicationTaskSettings)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getStopReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stopReason", stopReason)
    def getReplicationTaskCreationDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationTaskCreationDate",
        replicationTaskCreationDate
      )
    def getReplicationTaskStartDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("replicationTaskStartDate", replicationTaskStartDate)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getRecoveryCheckpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recoveryCheckpoint", recoveryCheckpoint)
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getReplicationTaskStats: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTaskStats", replicationTaskStats)
    def getTaskData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskData", taskData)
    def getTargetReplicationInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReplicationInstanceArn",
        targetReplicationInstanceArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTask
  ) extends zio.aws.databasemigration.model.ReplicationTask.ReadOnly {
    override val replicationTaskIdentifier: Option[String] =
      scala.Option(impl.replicationTaskIdentifier()).map(value => value: String)
    override val sourceEndpointArn: Option[String] =
      scala.Option(impl.sourceEndpointArn()).map(value => value: String)
    override val targetEndpointArn: Option[String] =
      scala.Option(impl.targetEndpointArn()).map(value => value: String)
    override val replicationInstanceArn: Option[String] =
      scala.Option(impl.replicationInstanceArn()).map(value => value: String)
    override val migrationType
        : Option[zio.aws.databasemigration.model.MigrationTypeValue] = scala
      .Option(impl.migrationType())
      .map(value =>
        zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
      )
    override val tableMappings: Option[String] =
      scala.Option(impl.tableMappings()).map(value => value: String)
    override val replicationTaskSettings: Option[String] =
      scala.Option(impl.replicationTaskSettings()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val lastFailureMessage: Option[String] =
      scala.Option(impl.lastFailureMessage()).map(value => value: String)
    override val stopReason: Option[String] =
      scala.Option(impl.stopReason()).map(value => value: String)
    override val replicationTaskCreationDate: Option[TStamp] = scala
      .Option(impl.replicationTaskCreationDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val replicationTaskStartDate: Option[TStamp] = scala
      .Option(impl.replicationTaskStartDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Option[String] =
      scala.Option(impl.cdcStartPosition()).map(value => value: String)
    override val cdcStopPosition: Option[String] =
      scala.Option(impl.cdcStopPosition()).map(value => value: String)
    override val recoveryCheckpoint: Option[String] =
      scala.Option(impl.recoveryCheckpoint()).map(value => value: String)
    override val replicationTaskArn: Option[String] =
      scala.Option(impl.replicationTaskArn()).map(value => value: String)
    override val replicationTaskStats: Option[
      zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly
    ] = scala
      .Option(impl.replicationTaskStats())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationTaskStats.wrap(value)
      )
    override val taskData: Option[String] =
      scala.Option(impl.taskData()).map(value => value: String)
    override val targetReplicationInstanceArn: Option[String] = scala
      .Option(impl.targetReplicationInstanceArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTask
  ): zio.aws.databasemigration.model.ReplicationTask.ReadOnly = new Wrapper(
    impl
  )
}
