package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class ElasticsearchSettings(
    serviceAccessRoleArn: String,
    endpointUri: String,
    fullLoadErrorPercentage: Option[IntegerOptional] = None,
    errorRetryDuration: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings = {
    import ElasticsearchSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
      .builder()
      .serviceAccessRoleArn(serviceAccessRoleArn: java.lang.String)
      .endpointUri(endpointUri: java.lang.String)
      .optionallyWith(fullLoadErrorPercentage.map(value => value: Integer))(
        _.fullLoadErrorPercentage
      )
      .optionallyWith(errorRetryDuration.map(value => value: Integer))(
        _.errorRetryDuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly =
    zio.aws.databasemigration.model.ElasticsearchSettings.wrap(buildAwsValue())
}
object ElasticsearchSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ElasticsearchSettings =
      zio.aws.databasemigration.model.ElasticsearchSettings(
        serviceAccessRoleArn,
        endpointUri,
        fullLoadErrorPercentage.map(value => value),
        errorRetryDuration.map(value => value)
      )
    def serviceAccessRoleArn: String
    def endpointUri: String
    def fullLoadErrorPercentage: Option[IntegerOptional]
    def errorRetryDuration: Option[IntegerOptional]
    def getServiceAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceAccessRoleArn)
    def getEndpointUri: ZIO[Any, Nothing, String] = ZIO.succeed(endpointUri)
    def getFullLoadErrorPercentage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "fullLoadErrorPercentage",
        fullLoadErrorPercentage
      )
    def getErrorRetryDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("errorRetryDuration", errorRetryDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
  ) extends zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly {
    override val serviceAccessRoleArn: String =
      impl.serviceAccessRoleArn(): String
    override val endpointUri: String = impl.endpointUri(): String
    override val fullLoadErrorPercentage: Option[IntegerOptional] = scala
      .Option(impl.fullLoadErrorPercentage())
      .map(value => value: IntegerOptional)
    override val errorRetryDuration: Option[IntegerOptional] = scala
      .Option(impl.errorRetryDuration())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
  ): zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly =
    new Wrapper(impl)
}
