package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribePendingMaintenanceActionsRequest(
    replicationInstanceArn: Option[String] = None,
    filters: Option[Iterable[zio.aws.databasemigration.model.Filter]] = None,
    marker: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest = {
    import DescribePendingMaintenanceActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
      .builder()
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
      .wrap(buildAwsValue())
}
object DescribePendingMaintenanceActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest =
      zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest(
        replicationInstanceArn.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def replicationInstanceArn: Option[String]
    def filters: Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def marker: Option[String]
    def maxRecords: Option[IntegerOptional]
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ) extends zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest.ReadOnly {
    override val replicationInstanceArn: Option[String] =
      scala.Option(impl.replicationInstanceArn()).map(value => value: String)
    override val filters
        : Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Filter.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ): zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest.ReadOnly =
    new Wrapper(impl)
}
