package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReloadTablesResponse(
    replicationTaskArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse = {
    import ReloadTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse
      .builder()
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly =
    zio.aws.databasemigration.model.ReloadTablesResponse.wrap(buildAwsValue())
}
object ReloadTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReloadTablesResponse =
      zio.aws.databasemigration.model
        .ReloadTablesResponse(replicationTaskArn.map(value => value))
    def replicationTaskArn: Option[String]
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse
  ) extends zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly {
    override val replicationTaskArn: Option[String] =
      scala.Option(impl.replicationTaskArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse
  ): zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly =
    new Wrapper(impl)
}
