package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReplicationTaskIndividualAssessmentsResponse(
    marker: Option[String] = None,
    replicationTaskIndividualAssessments: Option[Iterable[
      zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse = {
    import DescribeReplicationTaskIndividualAssessmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationTaskIndividualAssessments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationTaskIndividualAssessments)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationTaskIndividualAssessmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse =
      zio.aws.databasemigration.model
        .DescribeReplicationTaskIndividualAssessmentsResponse(
          marker.map(value => value),
          replicationTaskIndividualAssessments.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def marker: Option[String]
    def replicationTaskIndividualAssessments: Option[List[
      zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment.ReadOnly
    ]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationTaskIndividualAssessments: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationTaskIndividualAssessments",
      replicationTaskIndividualAssessments
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val replicationTaskIndividualAssessments: Option[List[
      zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment.ReadOnly
    ]] = scala
      .Option(impl.replicationTaskIndividualAssessments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly =
    new Wrapper(impl)
}
