package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  SecretString
}
import scala.jdk.CollectionConverters._
final case class SybaseSettings(
    databaseName: Option[String] = None,
    password: Option[SecretString] = None,
    port: Option[IntegerOptional] = None,
    serverName: Option[String] = None,
    username: Option[String] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SybaseSettings = {
    import SybaseSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SybaseSettings
      .builder()
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.SybaseSettings.ReadOnly =
    zio.aws.databasemigration.model.SybaseSettings.wrap(buildAwsValue())
}
object SybaseSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SybaseSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SybaseSettings =
      zio.aws.databasemigration.model.SybaseSettings(
        databaseName.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        username.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def databaseName: Option[String]
    def password: Option[SecretString]
    def port: Option[IntegerOptional]
    def serverName: Option[String]
    def username: Option[String]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SybaseSettings
  ) extends zio.aws.databasemigration.model.SybaseSettings.ReadOnly {
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SybaseSettings
  ): zio.aws.databasemigration.model.SybaseSettings.ReadOnly = new Wrapper(impl)
}
