package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{IntegerOptional, TStamp}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEventsRequest(
    sourceIdentifier: Option[String] = None,
    sourceType: Option[zio.aws.databasemigration.model.SourceType] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    duration: Option[IntegerOptional] = None,
    eventCategories: Option[Iterable[String]] = None,
    filters: Option[Iterable[zio.aws.databasemigration.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        duration.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.duration)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEventsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DescribeEventsRequest =
      zio.aws.databasemigration.model.DescribeEventsRequest(
        sourceIdentifier.map(value => value),
        sourceType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        duration.map(value => value),
        eventCategories.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def sourceIdentifier: Option[String]
    def sourceType: Option[zio.aws.databasemigration.model.SourceType]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def duration: Option[IntegerOptional]
    def eventCategories: Option[List[String]]
    def filters: Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("duration", duration)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest
  ) extends zio.aws.databasemigration.model.DescribeEventsRequest.ReadOnly {
    override val sourceIdentifier: Option[String] =
      scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override val sourceType
        : Option[zio.aws.databasemigration.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.databasemigration.model.SourceType.wrap(value))
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val duration: Option[IntegerOptional] = scala
      .Option(impl.duration())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val filters
        : Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest
  ): zio.aws.databasemigration.model.DescribeEventsRequest.ReadOnly =
    new Wrapper(impl)
}
