package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  SecretString
}
import scala.jdk.CollectionConverters._
final case class DocDbSettings(
    username: Option[String] = None,
    password: Option[SecretString] = None,
    serverName: Option[String] = None,
    port: Option[IntegerOptional] = None,
    databaseName: Option[String] = None,
    nestingLevel: Option[zio.aws.databasemigration.model.NestingLevelValue] =
      None,
    extractDocId: Option[BooleanOptional] = None,
    docsToInvestigate: Option[IntegerOptional] = None,
    kmsKeyId: Option[String] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DocDbSettings = {
    import DocDbSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DocDbSettings
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(nestingLevel.map(value => value.unwrap))(_.nestingLevel)
      .optionallyWith(
        extractDocId.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.extractDocId)
      .optionallyWith(
        docsToInvestigate.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.docsToInvestigate)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DocDbSettings.ReadOnly =
    zio.aws.databasemigration.model.DocDbSettings.wrap(buildAwsValue())
}
object DocDbSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DocDbSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DocDbSettings =
      zio.aws.databasemigration.model.DocDbSettings(
        username.map(value => value),
        password.map(value => value),
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        nestingLevel.map(value => value),
        extractDocId.map(value => value),
        docsToInvestigate.map(value => value),
        kmsKeyId.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def username: Option[String]
    def password: Option[SecretString]
    def serverName: Option[String]
    def port: Option[IntegerOptional]
    def databaseName: Option[String]
    def nestingLevel: Option[zio.aws.databasemigration.model.NestingLevelValue]
    def extractDocId: Option[BooleanOptional]
    def docsToInvestigate: Option[IntegerOptional]
    def kmsKeyId: Option[String]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getNestingLevel: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.NestingLevelValue
    ] = AwsError.unwrapOptionField("nestingLevel", nestingLevel)
    def getExtractDocId: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("extractDocId", extractDocId)
    def getDocsToInvestigate: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("docsToInvestigate", docsToInvestigate)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DocDbSettings
  ) extends zio.aws.databasemigration.model.DocDbSettings.ReadOnly {
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val nestingLevel
        : Option[zio.aws.databasemigration.model.NestingLevelValue] = scala
      .Option(impl.nestingLevel())
      .map(value =>
        zio.aws.databasemigration.model.NestingLevelValue.wrap(value)
      )
    override val extractDocId: Option[BooleanOptional] = scala
      .Option(impl.extractDocId())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val docsToInvestigate: Option[IntegerOptional] = scala
      .Option(impl.docsToInvestigate())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DocDbSettings
  ): zio.aws.databasemigration.model.DocDbSettings.ReadOnly = new Wrapper(impl)
}
