package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.{TStamp, Integer}
import scala.jdk.CollectionConverters._
final case class ReplicationInstance(
    replicationInstanceIdentifier: Option[String] = None,
    replicationInstanceClass: Option[String] = None,
    replicationInstanceStatus: Option[String] = None,
    allocatedStorage: Option[Integer] = None,
    instanceCreateTime: Option[TStamp] = None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.databasemigration.model.VpcSecurityGroupMembership]
    ] = None,
    availabilityZone: Option[String] = None,
    replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup
    ] = None,
    preferredMaintenanceWindow: Option[String] = None,
    pendingModifiedValues: Option[
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues
    ] = None,
    multiAZ: Option[Boolean] = None,
    engineVersion: Option[String] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    replicationInstanceArn: Option[String] = None,
    replicationInstancePublicIpAddress: Option[String] = None,
    replicationInstancePrivateIpAddress: Option[String] = None,
    replicationInstancePublicIpAddresses: Option[Iterable[String]] = None,
    replicationInstancePrivateIpAddresses: Option[Iterable[String]] = None,
    publiclyAccessible: Option[Boolean] = None,
    secondaryAvailabilityZone: Option[String] = None,
    freeUntil: Option[TStamp] = None,
    dnsNameServers: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationInstance = {
    import ReplicationInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
      .builder()
      .optionallyWith(
        replicationInstanceIdentifier.map(value => value: java.lang.String)
      )(_.replicationInstanceIdentifier)
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(
        replicationInstanceStatus.map(value => value: java.lang.String)
      )(_.replicationInstanceStatus)
      .optionallyWith(
        allocatedStorage.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.allocatedStorage)
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        replicationSubnetGroup.map(value => value.buildAwsValue())
      )(_.replicationSubnetGroup)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(
        replicationInstancePublicIpAddress.map(value => value: java.lang.String)
      )(_.replicationInstancePublicIpAddress)
      .optionallyWith(
        replicationInstancePrivateIpAddress.map(value =>
          value: java.lang.String
        )
      )(_.replicationInstancePrivateIpAddress)
      .optionallyWith(
        replicationInstancePublicIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationInstancePublicIpAddresses)
      .optionallyWith(
        replicationInstancePrivateIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationInstancePrivateIpAddresses)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(freeUntil.map(value => TStamp.unwrap(value): Instant))(
        _.freeUntil
      )
      .optionallyWith(dnsNameServers.map(value => value: java.lang.String))(
        _.dnsNameServers
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ReplicationInstance.ReadOnly =
    zio.aws.databasemigration.model.ReplicationInstance.wrap(buildAwsValue())
}
object ReplicationInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationInstance =
      zio.aws.databasemigration.model.ReplicationInstance(
        replicationInstanceIdentifier.map(value => value),
        replicationInstanceClass.map(value => value),
        replicationInstanceStatus.map(value => value),
        allocatedStorage.map(value => value),
        instanceCreateTime.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        replicationSubnetGroup.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        kmsKeyId.map(value => value),
        replicationInstanceArn.map(value => value),
        replicationInstancePublicIpAddress.map(value => value),
        replicationInstancePrivateIpAddress.map(value => value),
        replicationInstancePublicIpAddresses.map(value => value),
        replicationInstancePrivateIpAddresses.map(value => value),
        publiclyAccessible.map(value => value),
        secondaryAvailabilityZone.map(value => value),
        freeUntil.map(value => value),
        dnsNameServers.map(value => value)
      )
    def replicationInstanceIdentifier: Option[String]
    def replicationInstanceClass: Option[String]
    def replicationInstanceStatus: Option[String]
    def allocatedStorage: Option[Integer]
    def instanceCreateTime: Option[TStamp]
    def vpcSecurityGroups: Option[
      List[zio.aws.databasemigration.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def availabilityZone: Option[String]
    def replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ]
    def preferredMaintenanceWindow: Option[String]
    def pendingModifiedValues: Option[
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly
    ]
    def multiAZ: Option[Boolean]
    def engineVersion: Option[String]
    def autoMinorVersionUpgrade: Option[Boolean]
    def kmsKeyId: Option[String]
    def replicationInstanceArn: Option[String]
    def replicationInstancePublicIpAddress: Option[String]
    def replicationInstancePrivateIpAddress: Option[String]
    def replicationInstancePublicIpAddresses: Option[List[String]]
    def replicationInstancePrivateIpAddresses: Option[List[String]]
    def publiclyAccessible: Option[Boolean]
    def secondaryAvailabilityZone: Option[String]
    def freeUntil: Option[TStamp]
    def dnsNameServers: Option[String]
    def getReplicationInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstanceIdentifier",
        replicationInstanceIdentifier
      )
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getReplicationInstanceStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceStatus", replicationInstanceStatus)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getReplicationSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationSubnetGroup",
      replicationSubnetGroup
    )
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getReplicationInstancePublicIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstancePublicIpAddress",
        replicationInstancePublicIpAddress
      )
    def getReplicationInstancePrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstancePrivateIpAddress",
        replicationInstancePrivateIpAddress
      )
    def getReplicationInstancePublicIpAddresses
        : ZIO[Any, AwsError, List[String]] = AwsError.unwrapOptionField(
      "replicationInstancePublicIpAddresses",
      replicationInstancePublicIpAddresses
    )
    def getReplicationInstancePrivateIpAddresses
        : ZIO[Any, AwsError, List[String]] = AwsError.unwrapOptionField(
      "replicationInstancePrivateIpAddresses",
      replicationInstancePrivateIpAddresses
    )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZone)
    def getFreeUntil: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("freeUntil", freeUntil)
    def getDnsNameServers: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsNameServers", dnsNameServers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
  ) extends zio.aws.databasemigration.model.ReplicationInstance.ReadOnly {
    override val replicationInstanceIdentifier: Option[String] = scala
      .Option(impl.replicationInstanceIdentifier())
      .map(value => value: String)
    override val replicationInstanceClass: Option[String] =
      scala.Option(impl.replicationInstanceClass()).map(value => value: String)
    override val replicationInstanceStatus: Option[String] =
      scala.Option(impl.replicationInstanceStatus()).map(value => value: String)
    override val allocatedStorage: Option[Integer] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.databasemigration.model.primitives.Integer(value))
    override val instanceCreateTime: Option[TStamp] = scala
      .Option(impl.instanceCreateTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val vpcSecurityGroups: Option[
      List[zio.aws.databasemigration.model.VpcSecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = scala
      .Option(impl.replicationSubnetGroup())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationSubnetGroup.wrap(value)
      )
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val pendingModifiedValues: Option[
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly
    ] = scala
      .Option(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationPendingModifiedValues
          .wrap(value)
      )
    override val multiAZ: Option[Boolean] =
      scala.Option(impl.multiAZ()).map(value => value: Boolean)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[Boolean] =
      scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val replicationInstanceArn: Option[String] =
      scala.Option(impl.replicationInstanceArn()).map(value => value: String)
    override val replicationInstancePublicIpAddress: Option[String] = scala
      .Option(impl.replicationInstancePublicIpAddress())
      .map(value => value: String)
    override val replicationInstancePrivateIpAddress: Option[String] = scala
      .Option(impl.replicationInstancePrivateIpAddress())
      .map(value => value: String)
    override val replicationInstancePublicIpAddresses: Option[List[String]] =
      scala
        .Option(impl.replicationInstancePublicIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val replicationInstancePrivateIpAddresses: Option[List[String]] =
      scala
        .Option(impl.replicationInstancePrivateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val secondaryAvailabilityZone: Option[String] =
      scala.Option(impl.secondaryAvailabilityZone()).map(value => value: String)
    override val freeUntil: Option[TStamp] = scala
      .Option(impl.freeUntil())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val dnsNameServers: Option[String] =
      scala.Option(impl.dnsNameServers()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
  ): zio.aws.databasemigration.model.ReplicationInstance.ReadOnly = new Wrapper(
    impl
  )
}
