package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Connection(
    replicationInstanceArn: Option[String] = None,
    endpointArn: Option[String] = None,
    status: Option[String] = None,
    lastFailureMessage: Option[String] = None,
    endpointIdentifier: Option[String] = None,
    replicationInstanceIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.Connection = {
    import Connection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.Connection
      .builder()
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(endpointArn.map(value => value: java.lang.String))(
        _.endpointArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(endpointIdentifier.map(value => value: java.lang.String))(
        _.endpointIdentifier
      )
      .optionallyWith(
        replicationInstanceIdentifier.map(value => value: java.lang.String)
      )(_.replicationInstanceIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.Connection.ReadOnly =
    zio.aws.databasemigration.model.Connection.wrap(buildAwsValue())
}
object Connection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.Connection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.Connection =
      zio.aws.databasemigration.model.Connection(
        replicationInstanceArn.map(value => value),
        endpointArn.map(value => value),
        status.map(value => value),
        lastFailureMessage.map(value => value),
        endpointIdentifier.map(value => value),
        replicationInstanceIdentifier.map(value => value)
      )
    def replicationInstanceArn: Option[String]
    def endpointArn: Option[String]
    def status: Option[String]
    def lastFailureMessage: Option[String]
    def endpointIdentifier: Option[String]
    def replicationInstanceIdentifier: Option[String]
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getEndpointIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointIdentifier", endpointIdentifier)
    def getReplicationInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstanceIdentifier",
        replicationInstanceIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.Connection
  ) extends zio.aws.databasemigration.model.Connection.ReadOnly {
    override val replicationInstanceArn: Option[String] =
      scala.Option(impl.replicationInstanceArn()).map(value => value: String)
    override val endpointArn: Option[String] =
      scala.Option(impl.endpointArn()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val lastFailureMessage: Option[String] =
      scala.Option(impl.lastFailureMessage()).map(value => value: String)
    override val endpointIdentifier: Option[String] =
      scala.Option(impl.endpointIdentifier()).map(value => value: String)
    override val replicationInstanceIdentifier: Option[String] = scala
      .Option(impl.replicationInstanceIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.Connection
  ): zio.aws.databasemigration.model.Connection.ReadOnly = new Wrapper(impl)
}
