package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationInstanceTaskLogsRequest(
    replicationInstanceArn: String,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest = {
    import DescribeReplicationInstanceTaskLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationInstanceTaskLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest =
      zio.aws.databasemigration.model
        .DescribeReplicationInstanceTaskLogsRequest(
          replicationInstanceArn,
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def replicationInstanceArn: String
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ) extends zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ): zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.ReadOnly =
    new Wrapper(impl)
}
