package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeOrderableReplicationInstancesResponse(
    orderableReplicationInstances: Option[
      Iterable[zio.aws.databasemigration.model.OrderableReplicationInstance]
    ] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse = {
    import DescribeOrderableReplicationInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse
      .builder()
      .optionallyWith(
        orderableReplicationInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderableReplicationInstances)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse
      .wrap(buildAwsValue())
}
object DescribeOrderableReplicationInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse =
      zio.aws.databasemigration.model
        .DescribeOrderableReplicationInstancesResponse(
          orderableReplicationInstances.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          marker.map(value => value)
        )
    def orderableReplicationInstances: Option[List[
      zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly
    ]]
    def marker: Option[String]
    def getOrderableReplicationInstances: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "orderableReplicationInstances",
      orderableReplicationInstances
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse
  ) extends zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly {
    override val orderableReplicationInstances: Option[List[
      zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly
    ]] = scala
      .Option(impl.orderableReplicationInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.OrderableReplicationInstance
            .wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse
  ): zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
