package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEndpointsResponse(
    marker: Option[String] = None,
    endpoints: Option[Iterable[zio.aws.databasemigration.model.Endpoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse = {
    import DescribeEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeEndpointsResponse
      .wrap(buildAwsValue())
}
object DescribeEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DescribeEndpointsResponse =
      zio.aws.databasemigration.model.DescribeEndpointsResponse(
        marker.map(value => value),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def endpoints
        : Option[List[zio.aws.databasemigration.model.Endpoint.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Endpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse
  ) extends zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val endpoints
        : Option[List[zio.aws.databasemigration.model.Endpoint.ReadOnly]] =
      scala
        .Option(impl.endpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Endpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse
  ): zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
