package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait ReloadOptionValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue
}
object ReloadOptionValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue
  ): zio.aws.databasemigration.model.ReloadOptionValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue.DATA_RELOAD =>
      val r = `data-reload`
      r
    case software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue.VALIDATE_ONLY =>
      val r = `validate-only`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.ReloadOptionValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue =
      software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue.UNKNOWN_TO_SDK_VERSION
  }
  case object `data-reload`
      extends zio.aws.databasemigration.model.ReloadOptionValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue =
      software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue.DATA_RELOAD
  }
  case object `validate-only`
      extends zio.aws.databasemigration.model.ReloadOptionValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue =
      software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue.VALIDATE_ONLY
  }
}
