package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  SecretString
}
import scala.jdk.CollectionConverters._
final case class IBMDb2Settings(
    databaseName: Option[String] = None,
    password: Option[SecretString] = None,
    port: Option[IntegerOptional] = None,
    serverName: Option[String] = None,
    setDataCaptureChanges: Option[BooleanOptional] = None,
    currentLsn: Option[String] = None,
    maxKBytesPerRead: Option[IntegerOptional] = None,
    username: Option[String] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings = {
    import IBMDb2Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
      .builder()
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        setDataCaptureChanges.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.setDataCaptureChanges)
      .optionallyWith(currentLsn.map(value => value: java.lang.String))(
        _.currentLsn
      )
      .optionallyWith(
        maxKBytesPerRead.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxKBytesPerRead)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly =
    zio.aws.databasemigration.model.IBMDb2Settings.wrap(buildAwsValue())
}
object IBMDb2Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.IBMDb2Settings =
      zio.aws.databasemigration.model.IBMDb2Settings(
        databaseName.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        setDataCaptureChanges.map(value => value),
        currentLsn.map(value => value),
        maxKBytesPerRead.map(value => value),
        username.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def databaseName: Option[String]
    def password: Option[SecretString]
    def port: Option[IntegerOptional]
    def serverName: Option[String]
    def setDataCaptureChanges: Option[BooleanOptional]
    def currentLsn: Option[String]
    def maxKBytesPerRead: Option[IntegerOptional]
    def username: Option[String]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getSetDataCaptureChanges: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("setDataCaptureChanges", setDataCaptureChanges)
    def getCurrentLsn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentLsn", currentLsn)
    def getMaxKBytesPerRead: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxKBytesPerRead", maxKBytesPerRead)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
  ) extends zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly {
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val setDataCaptureChanges: Option[BooleanOptional] = scala
      .Option(impl.setDataCaptureChanges())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val currentLsn: Option[String] =
      scala.Option(impl.currentLsn()).map(value => value: String)
    override val maxKBytesPerRead: Option[IntegerOptional] = scala
      .Option(impl.maxKBytesPerRead())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings
  ): zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly = new Wrapper(impl)
}
