package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyEndpointResponse(
    endpoint: Option[zio.aws.databasemigration.model.Endpoint] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse = {
    import ModifyEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyEndpointResponse.wrap(buildAwsValue())
}
object ModifyEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ModifyEndpointResponse =
      zio.aws.databasemigration.model
        .ModifyEndpointResponse(endpoint.map(value => value.asEditable))
    def endpoint: Option[zio.aws.databasemigration.model.Endpoint.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Endpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse
  ) extends zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly {
    override val endpoint
        : Option[zio.aws.databasemigration.model.Endpoint.ReadOnly] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.databasemigration.model.Endpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse
  ): zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
