package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeConnectionsResponse(
    marker: Option[String] = None,
    connections: Option[Iterable[zio.aws.databasemigration.model.Connection]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse = {
    import DescribeConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeConnectionsResponse =
      zio.aws.databasemigration.model.DescribeConnectionsResponse(
        marker.map(value => value),
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def connections
        : Option[List[zio.aws.databasemigration.model.Connection.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
  ) extends zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val connections
        : Option[List[zio.aws.databasemigration.model.Connection.ReadOnly]] =
      scala
        .Option(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Connection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
  ): zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
