package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReplicationInstanceTaskLogsResponse(
    replicationInstanceArn: Option[String] = None,
    replicationInstanceTaskLogs: Option[
      Iterable[zio.aws.databasemigration.model.ReplicationInstanceTaskLog]
    ] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse = {
    import DescribeReplicationInstanceTaskLogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse
      .builder()
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(
        replicationInstanceTaskLogs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationInstanceTaskLogs)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationInstanceTaskLogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse =
      zio.aws.databasemigration.model
        .DescribeReplicationInstanceTaskLogsResponse(
          replicationInstanceArn.map(value => value),
          replicationInstanceTaskLogs.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          marker.map(value => value)
        )
    def replicationInstanceArn: Option[String]
    def replicationInstanceTaskLogs: Option[
      List[zio.aws.databasemigration.model.ReplicationInstanceTaskLog.ReadOnly]
    ]
    def marker: Option[String]
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getReplicationInstanceTaskLogs: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationInstanceTaskLog.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationInstanceTaskLogs",
      replicationInstanceTaskLogs
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly {
    override val replicationInstanceArn: Option[String] =
      scala.Option(impl.replicationInstanceArn()).map(value => value: String)
    override val replicationInstanceTaskLogs: Option[
      List[zio.aws.databasemigration.model.ReplicationInstanceTaskLog.ReadOnly]
    ] = scala
      .Option(impl.replicationInstanceTaskLogs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationInstanceTaskLog.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly =
    new Wrapper(impl)
}
