package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyReplicationConfigRequest(
    replicationConfigArn: String,
    replicationConfigIdentifier: Optional[String] = Optional.Absent,
    replicationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    tableMappings: Optional[String] = Optional.Absent,
    replicationSettings: Optional[String] = Optional.Absent,
    supplementalSettings: Optional[String] = Optional.Absent,
    computeConfig: Optional[zio.aws.databasemigration.model.ComputeConfig] =
      Optional.Absent,
    sourceEndpointArn: Optional[String] = Optional.Absent,
    targetEndpointArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest = {
    import ModifyReplicationConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest
      .builder()
      .replicationConfigArn(replicationConfigArn: java.lang.String)
      .optionallyWith(
        replicationConfigIdentifier.map(value => value: java.lang.String)
      )(_.replicationConfigIdentifier)
      .optionallyWith(replicationType.map(value => value.unwrap))(
        _.replicationType
      )
      .optionallyWith(tableMappings.map(value => value: java.lang.String))(
        _.tableMappings
      )
      .optionallyWith(
        replicationSettings.map(value => value: java.lang.String)
      )(_.replicationSettings)
      .optionallyWith(
        supplementalSettings.map(value => value: java.lang.String)
      )(_.supplementalSettings)
      .optionallyWith(computeConfig.map(value => value.buildAwsValue()))(
        _.computeConfig
      )
      .optionallyWith(sourceEndpointArn.map(value => value: java.lang.String))(
        _.sourceEndpointArn
      )
      .optionallyWith(targetEndpointArn.map(value => value: java.lang.String))(
        _.targetEndpointArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationConfigRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationConfigRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationConfigRequest =
      zio.aws.databasemigration.model.ModifyReplicationConfigRequest(
        replicationConfigArn,
        replicationConfigIdentifier.map(value => value),
        replicationType.map(value => value),
        tableMappings.map(value => value),
        replicationSettings.map(value => value),
        supplementalSettings.map(value => value),
        computeConfig.map(value => value.asEditable),
        sourceEndpointArn.map(value => value),
        targetEndpointArn.map(value => value)
      )
    def replicationConfigArn: String
    def replicationConfigIdentifier: Optional[String]
    def replicationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def tableMappings: Optional[String]
    def replicationSettings: Optional[String]
    def supplementalSettings: Optional[String]
    def computeConfig
        : Optional[zio.aws.databasemigration.model.ComputeConfig.ReadOnly]
    def sourceEndpointArn: Optional[String]
    def targetEndpointArn: Optional[String]
    def getReplicationConfigArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationConfigArn)
    def getReplicationConfigIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationConfigIdentifier",
        replicationConfigIdentifier
      )
    def getReplicationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("replicationType", replicationType)
    def getTableMappings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableMappings", tableMappings)
    def getReplicationSettings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationSettings", replicationSettings)
    def getSupplementalSettings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supplementalSettings", supplementalSettings)
    def getComputeConfig: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ComputeConfig.ReadOnly
    ] = AwsError.unwrapOptionField("computeConfig", computeConfig)
    def getSourceEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceEndpointArn", sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEndpointArn", targetEndpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest
  ) extends zio.aws.databasemigration.model.ModifyReplicationConfigRequest.ReadOnly {
    override val replicationConfigArn: String =
      impl.replicationConfigArn(): String
    override val replicationConfigIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfigIdentifier())
        .map(value => value: String)
    override val replicationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val tableMappings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableMappings())
      .map(value => value: String)
    override val replicationSettings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationSettings())
      .map(value => value: String)
    override val supplementalSettings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementalSettings())
      .map(value => value: String)
    override val computeConfig
        : Optional[zio.aws.databasemigration.model.ComputeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeConfig())
        .map(value => zio.aws.databasemigration.model.ComputeConfig.wrap(value))
    override val sourceEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceEndpointArn())
      .map(value => value: String)
    override val targetEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetEndpointArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest
  ): zio.aws.databasemigration.model.ModifyReplicationConfigRequest.ReadOnly =
    new Wrapper(impl)
}
