package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceProfileRequest(
    instanceProfileIdentifier: String,
    availabilityZone: Optional[String] = Optional.Absent,
    kmsKeyArn: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent,
    instanceProfileName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    subnetGroupIdentifier: Optional[String] = Optional.Absent,
    vpcSecurityGroups: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest = {
    import ModifyInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest
      .builder()
      .instanceProfileIdentifier(instanceProfileIdentifier: java.lang.String)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .optionallyWith(
        instanceProfileName.map(value => value: java.lang.String)
      )(_.instanceProfileName)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        subnetGroupIdentifier.map(value => value: java.lang.String)
      )(_.subnetGroupIdentifier)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyInstanceProfileRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyInstanceProfileRequest
      .wrap(buildAwsValue())
}
object ModifyInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyInstanceProfileRequest =
      zio.aws.databasemigration.model.ModifyInstanceProfileRequest(
        instanceProfileIdentifier,
        availabilityZone.map(value => value),
        kmsKeyArn.map(value => value),
        publiclyAccessible.map(value => value),
        networkType.map(value => value),
        instanceProfileName.map(value => value),
        description.map(value => value),
        subnetGroupIdentifier.map(value => value),
        vpcSecurityGroups.map(value => value)
      )
    def instanceProfileIdentifier: String
    def availabilityZone: Optional[String]
    def kmsKeyArn: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def networkType: Optional[String]
    def instanceProfileName: Optional[String]
    def description: Optional[String]
    def subnetGroupIdentifier: Optional[String]
    def vpcSecurityGroups: Optional[List[String]]
    def getInstanceProfileIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(instanceProfileIdentifier)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getInstanceProfileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceProfileName", instanceProfileName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSubnetGroupIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupIdentifier", subnetGroupIdentifier)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest
  ) extends zio.aws.databasemigration.model.ModifyInstanceProfileRequest.ReadOnly {
    override val instanceProfileIdentifier: String =
      impl.instanceProfileIdentifier(): String
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val kmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
    override val instanceProfileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceProfileName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val subnetGroupIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupIdentifier())
      .map(value => value: String)
    override val vpcSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest
  ): zio.aws.databasemigration.model.ModifyInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
