package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyConversionConfigurationRequest(
    migrationProjectIdentifier: String,
    conversionConfiguration: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest = {
    import ModifyConversionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .conversionConfiguration(conversionConfiguration: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyConversionConfigurationRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyConversionConfigurationRequest
      .wrap(buildAwsValue())
}
object ModifyConversionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyConversionConfigurationRequest =
      zio.aws.databasemigration.model.ModifyConversionConfigurationRequest(
        migrationProjectIdentifier,
        conversionConfiguration
      )
    def migrationProjectIdentifier: String
    def conversionConfiguration: String
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getConversionConfiguration: ZIO[Any, Nothing, String] =
      ZIO.succeed(conversionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest
  ) extends zio.aws.databasemigration.model.ModifyConversionConfigurationRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val conversionConfiguration: String =
      impl.conversionConfiguration(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest
  ): zio.aws.databasemigration.model.ModifyConversionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
