package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeConversionConfigurationResponse(
    migrationProjectIdentifier: Optional[String] = Optional.Absent,
    conversionConfiguration: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse = {
    import DescribeConversionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse
      .builder()
      .optionallyWith(
        migrationProjectIdentifier.map(value => value: java.lang.String)
      )(_.migrationProjectIdentifier)
      .optionallyWith(
        conversionConfiguration.map(value => value: java.lang.String)
      )(_.conversionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeConversionConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeConversionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeConversionConfigurationResponse =
      zio.aws.databasemigration.model.DescribeConversionConfigurationResponse(
        migrationProjectIdentifier.map(value => value),
        conversionConfiguration.map(value => value)
      )
    def migrationProjectIdentifier: Optional[String]
    def conversionConfiguration: Optional[String]
    def getMigrationProjectIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "migrationProjectIdentifier",
        migrationProjectIdentifier
      )
    def getConversionConfiguration: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("conversionConfiguration", conversionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse
  ) extends zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly {
    override val migrationProjectIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationProjectIdentifier())
        .map(value => value: String)
    override val conversionConfiguration: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversionConfiguration())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse
  ): zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
