package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataProviderResponse(
    dataProvider: Optional[zio.aws.databasemigration.model.DataProvider] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse = {
    import CreateDataProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse
      .builder()
      .optionallyWith(dataProvider.map(value => value.buildAwsValue()))(
        _.dataProvider
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateDataProviderResponse
      .wrap(buildAwsValue())
}
object CreateDataProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CreateDataProviderResponse =
      zio.aws.databasemigration.model
        .CreateDataProviderResponse(dataProvider.map(value => value.asEditable))
    def dataProvider
        : Optional[zio.aws.databasemigration.model.DataProvider.ReadOnly]
    def getDataProvider: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataProvider.ReadOnly
    ] = AwsError.unwrapOptionField("dataProvider", dataProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse
  ) extends zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly {
    override val dataProvider
        : Optional[zio.aws.databasemigration.model.DataProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProvider())
        .map(value => zio.aws.databasemigration.model.DataProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse
  ): zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly =
    new Wrapper(impl)
}
