package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeRecommendationLimitationsResponse(
    nextToken: Optional[String] = Optional.Absent,
    limitations: Optional[
      Iterable[zio.aws.databasemigration.model.Limitation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse = {
    import DescribeRecommendationLimitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        limitations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.limitations)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse
      .wrap(buildAwsValue())
}
object DescribeRecommendationLimitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse =
      zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse(
        nextToken.map(value => value),
        limitations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def limitations
        : Optional[List[zio.aws.databasemigration.model.Limitation.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimitations: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Limitation.ReadOnly
    ]] = AwsError.unwrapOptionField("limitations", limitations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse
  ) extends zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val limitations
        : Optional[List[zio.aws.databasemigration.model.Limitation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limitations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Limitation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse
  ): zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly =
    new Wrapper(impl)
}
