package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMigrationProjectRequest(
    migrationProjectIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest = {
    import DeleteMigrationProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteMigrationProjectRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteMigrationProjectRequest
      .wrap(buildAwsValue())
}
object DeleteMigrationProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteMigrationProjectRequest =
      zio.aws.databasemigration.model
        .DeleteMigrationProjectRequest(migrationProjectIdentifier)
    def migrationProjectIdentifier: String
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest
  ) extends zio.aws.databasemigration.model.DeleteMigrationProjectRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest
  ): zio.aws.databasemigration.model.DeleteMigrationProjectRequest.ReadOnly =
    new Wrapper(impl)
}
