package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ComputeConfig(
    availabilityZone: Optional[String] = Optional.Absent,
    dnsNameServers: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    maxCapacityUnits: Optional[IntegerOptional] = Optional.Absent,
    minCapacityUnits: Optional[IntegerOptional] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    replicationSubnetGroupId: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ComputeConfig = {
    import ComputeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ComputeConfig
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dnsNameServers.map(value => value: java.lang.String))(
        _.dnsNameServers
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(maxCapacityUnits.map(value => value: Integer))(
        _.maxCapacityUnits
      )
      .optionallyWith(minCapacityUnits.map(value => value: Integer))(
        _.minCapacityUnits
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        replicationSubnetGroupId.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupId)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ComputeConfig.ReadOnly =
    zio.aws.databasemigration.model.ComputeConfig.wrap(buildAwsValue())
}
object ComputeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ComputeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ComputeConfig =
      zio.aws.databasemigration.model.ComputeConfig(
        availabilityZone.map(value => value),
        dnsNameServers.map(value => value),
        kmsKeyId.map(value => value),
        maxCapacityUnits.map(value => value),
        minCapacityUnits.map(value => value),
        multiAZ.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        replicationSubnetGroupId.map(value => value),
        vpcSecurityGroupIds.map(value => value)
      )
    def availabilityZone: Optional[String]
    def dnsNameServers: Optional[String]
    def kmsKeyId: Optional[String]
    def maxCapacityUnits: Optional[IntegerOptional]
    def minCapacityUnits: Optional[IntegerOptional]
    def multiAZ: Optional[BooleanOptional]
    def preferredMaintenanceWindow: Optional[String]
    def replicationSubnetGroupId: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDnsNameServers: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsNameServers", dnsNameServers)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getMaxCapacityUnits: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxCapacityUnits", maxCapacityUnits)
    def getMinCapacityUnits: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minCapacityUnits", minCapacityUnits)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReplicationSubnetGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationSubnetGroupId", replicationSubnetGroupId)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ComputeConfig
  ) extends zio.aws.databasemigration.model.ComputeConfig.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val dnsNameServers: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsNameServers())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val maxCapacityUnits: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxCapacityUnits())
        .map(value => value: IntegerOptional)
    override val minCapacityUnits: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minCapacityUnits())
        .map(value => value: IntegerOptional)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val replicationSubnetGroupId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSubnetGroupId())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ComputeConfig
  ): zio.aws.databasemigration.model.ComputeConfig.ReadOnly = new Wrapper(impl)
}
