package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchStartRecommendationsErrorEntry(
    databaseId: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    code: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsErrorEntry = {
    import BatchStartRecommendationsErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsErrorEntry
      .builder()
      .optionallyWith(databaseId.map(value => value: java.lang.String))(
        _.databaseId
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry.ReadOnly =
    zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry
      .wrap(buildAwsValue())
}
object BatchStartRecommendationsErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry =
      zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry(
        databaseId.map(value => value),
        message.map(value => value),
        code.map(value => value)
      )
    def databaseId: Optional[String]
    def message: Optional[String]
    def code: Optional[String]
    def getDatabaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsErrorEntry
  ) extends zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry.ReadOnly {
    override val databaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsErrorEntry
  ): zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry.ReadOnly =
    new Wrapper(impl)
}
