package zio.aws.databasemigration
import zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient
import zio.aws.core.AwsError
import zio.aws.databasemigration.model.{
  DescribeEventCategoriesRequest,
  CreateEndpointRequest,
  DeleteDataProviderRequest,
  StartRecommendationsRequest,
  DescribeConversionConfigurationRequest,
  DescribeReplicationTaskAssessmentRunsRequest,
  CreateReplicationConfigRequest,
  DescribeRefreshSchemasStatusRequest,
  StopReplicationTaskRequest,
  StartMetadataModelAssessmentRequest,
  CreateDataProviderRequest,
  DescribeApplicableIndividualAssessmentsRequest,
  CreateMigrationProjectRequest,
  DescribeReplicationConfigsRequest,
  ModifyEventSubscriptionRequest,
  DescribeFleetAdvisorLsaAnalysisRequest,
  DescribeReplicationTaskAssessmentResultsRequest,
  DeleteEndpointRequest,
  UpdateSubscriptionsToEventBridgeRequest,
  DescribeReplicationTableStatisticsRequest,
  ModifyReplicationTaskRequest,
  DescribeSchemasRequest,
  StartMetadataModelExportAsScriptRequest,
  TestConnectionRequest,
  DescribeEndpointsRequest,
  DescribeMetadataModelConversionsRequest,
  ModifyReplicationInstanceRequest,
  CreateInstanceProfileRequest,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  ModifyMigrationProjectRequest,
  DescribeFleetAdvisorDatabasesRequest,
  StartMetadataModelExportToTargetRequest,
  StartReplicationTaskAssessmentRunRequest,
  DeleteReplicationTaskAssessmentRunRequest,
  DescribeConnectionsRequest,
  DescribeEngineVersionsRequest,
  DescribeEventsRequest,
  DescribeFleetAdvisorSchemasRequest,
  ApplyPendingMaintenanceActionRequest,
  StartReplicationTaskRequest,
  StartReplicationRequest,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  DescribeFleetAdvisorCollectorsRequest,
  DescribeReplicationsRequest,
  DescribeReplicationInstanceTaskLogsRequest,
  DescribeReplicationSubnetGroupsRequest,
  DeleteInstanceProfileRequest,
  DeleteFleetAdvisorDatabasesRequest,
  StartMetadataModelConversionRequest,
  CreateReplicationTaskRequest,
  DeleteReplicationSubnetGroupRequest,
  ModifyConversionConfigurationRequest,
  ModifyDataProviderRequest,
  DescribeMetadataModelExportsToTargetRequest,
  DeleteConnectionRequest,
  DescribeEndpointTypesRequest,
  ReloadTablesRequest,
  CreateFleetAdvisorCollectorRequest,
  DescribeOrderableReplicationInstancesRequest,
  RemoveTagsFromResourceRequest,
  DeleteReplicationTaskRequest,
  DescribeFleetAdvisorSchemaObjectSummaryRequest,
  DeleteFleetAdvisorCollectorRequest,
  StartExtensionPackAssociationRequest,
  DescribeCertificatesRequest,
  BatchStartRecommendationsRequest,
  DescribePendingMaintenanceActionsRequest,
  DescribeTableStatisticsRequest,
  CreateReplicationInstanceRequest,
  DescribeMetadataModelAssessmentsRequest,
  RebootReplicationInstanceRequest,
  ModifyReplicationSubnetGroupRequest,
  MoveReplicationTaskRequest,
  DescribeInstanceProfilesRequest,
  ExportMetadataModelAssessmentRequest,
  DescribeRecommendationLimitationsRequest,
  DescribeReplicationTaskIndividualAssessmentsRequest,
  DescribeAccountAttributesRequest,
  DescribeMetadataModelImportsRequest,
  DescribeReplicationTasksRequest,
  DescribeDataProvidersRequest,
  StopReplicationRequest,
  DeleteMigrationProjectRequest,
  StartMetadataModelImportRequest,
  ImportCertificateRequest,
  DeleteReplicationConfigRequest,
  ModifyReplicationConfigRequest,
  DescribeMetadataModelExportsAsScriptRequest,
  ModifyInstanceProfileRequest,
  DescribeReplicationInstancesRequest,
  CreateReplicationSubnetGroupRequest,
  DescribeEndpointSettingsRequest,
  RefreshSchemasRequest,
  DeleteReplicationInstanceRequest,
  DescribeEventSubscriptionsRequest,
  ReloadReplicationTablesRequest,
  DescribeExtensionPackAssociationsRequest,
  CancelReplicationTaskAssessmentRunRequest,
  DeleteCertificateRequest,
  ModifyEndpointRequest,
  DescribeMigrationProjectsRequest,
  DescribeRecommendationsRequest,
  StartReplicationTaskAssessmentRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object DatabaseMigrationMock extends Mock[DatabaseMigration] {
  object ModifyInstanceProfile
      extends Effect[
        ModifyInstanceProfileRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyInstanceProfileResponse.ReadOnly
      ]
  object DescribeFleetAdvisorCollectors
      extends Stream[
        DescribeFleetAdvisorCollectorsRequest,
        AwsError,
        zio.aws.databasemigration.model.CollectorResponse.ReadOnly
      ]
  object DescribeFleetAdvisorCollectorsPaginated
      extends Effect[
        DescribeFleetAdvisorCollectorsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
      ]
  object StopReplication
      extends Effect[
        StopReplicationRequest,
        AwsError,
        zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly
      ]
  object ModifyConversionConfiguration
      extends Effect[
        ModifyConversionConfigurationRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly
      ]
  object StartMetadataModelAssessment
      extends Effect[
        StartMetadataModelAssessmentRequest,
        AwsError,
        zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly
      ]
  object AddTagsToResource
      extends Effect[
        AddTagsToResourceRequest,
        AwsError,
        zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
      ]
  object DescribeOrderableReplicationInstances
      extends Effect[
        DescribeOrderableReplicationInstancesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
      ]
  object DeleteMigrationProject
      extends Effect[
        DeleteMigrationProjectRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly
      ]
  object DeleteDataProvider
      extends Effect[
        DeleteDataProviderRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteDataProviderResponse.ReadOnly
      ]
  object DescribeReplicationInstanceTaskLogs
      extends Effect[
        DescribeReplicationInstanceTaskLogsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
      ]
  object DescribePendingMaintenanceActions
      extends Effect[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
      ]
  object RefreshSchemas
      extends Effect[
        RefreshSchemasRequest,
        AwsError,
        zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
      ]
  object DescribeTableStatistics
      extends Effect[
        DescribeTableStatisticsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
      ]
  object DeleteReplicationSubnetGroup
      extends Effect[
        DeleteReplicationSubnetGroupRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
      ]
  object StopReplicationTask
      extends Effect[
        StopReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
      ]
  object StartMetadataModelExportToTarget
      extends Effect[
        StartMetadataModelExportToTargetRequest,
        AwsError,
        zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly
      ]
  object CancelReplicationTaskAssessmentRun
      extends Effect[
        CancelReplicationTaskAssessmentRunRequest,
        AwsError,
        zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
      ]
  object DescribeMetadataModelExportsToTarget
      extends Effect[
        DescribeMetadataModelExportsToTargetRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly
      ]
  object DescribeRefreshSchemasStatus
      extends Effect[
        DescribeRefreshSchemasStatusRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
      ]
  object StartReplicationTask
      extends Effect[
        StartReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
      ]
  object DescribeCertificates
      extends Effect[
        DescribeCertificatesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
      ]
  object ModifyReplicationTask
      extends Effect[
        ModifyReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
      ]
  object DeleteEventSubscription
      extends Effect[
        DeleteEventSubscriptionRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
      ]
  object MoveReplicationTask
      extends Effect[
        MoveReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
      ]
  object ModifyMigrationProject
      extends Effect[
        ModifyMigrationProjectRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyMigrationProjectResponse.ReadOnly
      ]
  object StartReplicationTaskAssessment
      extends Effect[
        StartReplicationTaskAssessmentRequest,
        AwsError,
        zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
      ]
  object DescribeReplicationSubnetGroups
      extends Effect[
        DescribeReplicationSubnetGroupsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
      ]
  object StartReplication
      extends Effect[
        StartReplicationRequest,
        AwsError,
        zio.aws.databasemigration.model.StartReplicationResponse.ReadOnly
      ]
  object DescribeFleetAdvisorSchemaObjectSummary
      extends Stream[
        DescribeFleetAdvisorSchemaObjectSummaryRequest,
        AwsError,
        zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
      ]
  object DescribeFleetAdvisorSchemaObjectSummaryPaginated
      extends Effect[
        DescribeFleetAdvisorSchemaObjectSummaryRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[
        RemoveTagsFromResourceRequest,
        AwsError,
        zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
      ]
  object CreateMigrationProject
      extends Effect[
        CreateMigrationProjectRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateMigrationProjectResponse.ReadOnly
      ]
  object DescribeReplicationTasks
      extends Effect[
        DescribeReplicationTasksRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
      ]
  object CreateReplicationSubnetGroup
      extends Effect[
        CreateReplicationSubnetGroupRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
      ]
  object DescribeReplicationTaskIndividualAssessments
      extends Effect[
        DescribeReplicationTaskIndividualAssessmentsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
      ]
  object ApplyPendingMaintenanceAction
      extends Effect[
        ApplyPendingMaintenanceActionRequest,
        AwsError,
        zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
      ]
  object DescribeExtensionPackAssociations
      extends Effect[
        DescribeExtensionPackAssociationsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeExtensionPackAssociationsResponse.ReadOnly
      ]
  object CreateDataProvider
      extends Effect[
        CreateDataProviderRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly
      ]
  object DescribeReplicationTaskAssessmentResults
      extends Effect[
        DescribeReplicationTaskAssessmentResultsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
      ]
  object DescribeReplicationTableStatistics
      extends Effect[
        DescribeReplicationTableStatisticsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly
      ]
  object DeleteCertificate
      extends Effect[
        DeleteCertificateRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
      ]
  object DeleteEndpoint
      extends Effect[
        DeleteEndpointRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
      ]
  object ModifyReplicationSubnetGroup
      extends Effect[
        ModifyReplicationSubnetGroupRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
      ]
  object DescribeRecommendationLimitations
      extends Stream[
        DescribeRecommendationLimitationsRequest,
        AwsError,
        zio.aws.databasemigration.model.Limitation.ReadOnly
      ]
  object DescribeRecommendationLimitationsPaginated
      extends Effect[
        DescribeRecommendationLimitationsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly
      ]
  object StartExtensionPackAssociation
      extends Effect[
        StartExtensionPackAssociationRequest,
        AwsError,
        zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly
      ]
  object ModifyReplicationInstance
      extends Effect[
        ModifyReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
      ]
  object StartMetadataModelConversion
      extends Effect[
        StartMetadataModelConversionRequest,
        AwsError,
        zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly
      ]
  object TestConnection
      extends Effect[
        TestConnectionRequest,
        AwsError,
        zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
      ]
  object DescribeMetadataModelExportsAsScript
      extends Effect[
        DescribeMetadataModelExportsAsScriptRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse.ReadOnly
      ]
  object DeleteReplicationTaskAssessmentRun
      extends Effect[
        DeleteReplicationTaskAssessmentRunRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
      ]
  object DescribeFleetAdvisorSchemas
      extends Stream[
        DescribeFleetAdvisorSchemasRequest,
        AwsError,
        zio.aws.databasemigration.model.SchemaResponse.ReadOnly
      ]
  object DescribeFleetAdvisorSchemasPaginated
      extends Effect[
        DescribeFleetAdvisorSchemasRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
      ]
  object CreateReplicationTask
      extends Effect[
        CreateReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
      ]
  object DescribeMetadataModelConversions
      extends Effect[
        DescribeMetadataModelConversionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly
      ]
  object DescribeFleetAdvisorDatabases
      extends Stream[
        DescribeFleetAdvisorDatabasesRequest,
        AwsError,
        zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
      ]
  object DescribeFleetAdvisorDatabasesPaginated
      extends Effect[
        DescribeFleetAdvisorDatabasesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
      ]
  object DescribeRecommendations
      extends Stream[
        DescribeRecommendationsRequest,
        AwsError,
        zio.aws.databasemigration.model.Recommendation.ReadOnly
      ]
  object DescribeRecommendationsPaginated
      extends Effect[
        DescribeRecommendationsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly
      ]
  object ModifyEventSubscription
      extends Effect[
        ModifyEventSubscriptionRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
      ]
  object UpdateSubscriptionsToEventBridge
      extends Effect[
        UpdateSubscriptionsToEventBridgeRequest,
        AwsError,
        zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
      ]
  object ModifyDataProvider
      extends Effect[
        ModifyDataProviderRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyDataProviderResponse.ReadOnly
      ]
  object DescribeReplicationInstances
      extends Effect[
        DescribeReplicationInstancesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
      ]
  object StartMetadataModelExportAsScript
      extends Effect[
        StartMetadataModelExportAsScriptRequest,
        AwsError,
        ReadOnly
      ]
  object DescribeEventCategories
      extends Effect[
        DescribeEventCategoriesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
      ]
  object CreateReplicationInstance
      extends Effect[
        CreateReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
      ]
  object DeleteReplicationInstance
      extends Effect[
        DeleteReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
      ]
  object ModifyReplicationConfig
      extends Effect[
        ModifyReplicationConfigRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly
      ]
  object DescribeReplicationConfigs
      extends Effect[
        DescribeReplicationConfigsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly
      ]
  object DescribeEngineVersions
      extends Effect[
        DescribeEngineVersionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly
      ]
  object CreateFleetAdvisorCollector
      extends Effect[
        CreateFleetAdvisorCollectorRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
      ]
  object DeleteInstanceProfile
      extends Effect[
        DeleteInstanceProfileRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly
      ]
  object DescribeApplicableIndividualAssessments
      extends Effect[
        DescribeApplicableIndividualAssessmentsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
      ]
  object DescribeReplicationTaskAssessmentRuns
      extends Effect[
        DescribeReplicationTaskAssessmentRunsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
      ]
  object DescribeMetadataModelAssessments
      extends Effect[
        DescribeMetadataModelAssessmentsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly
      ]
  object ReloadReplicationTables
      extends Effect[
        ReloadReplicationTablesRequest,
        AwsError,
        zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly
      ]
  object DescribeEndpoints
      extends Effect[
        DescribeEndpointsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
      ]
  object StartReplicationTaskAssessmentRun
      extends Effect[
        StartReplicationTaskAssessmentRunRequest,
        AwsError,
        zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
      ]
  object DescribeSchemas
      extends Effect[
        DescribeSchemasRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
      ]
  object CreateEventSubscription
      extends Effect[
        CreateEventSubscriptionRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
      ]
  object DescribeConversionConfiguration
      extends Effect[
        DescribeConversionConfigurationRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly
      ]
  object DescribeEndpointSettings
      extends Effect[
        DescribeEndpointSettingsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ModifyEndpoint
      extends Effect[
        ModifyEndpointRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
      ]
  object StartRecommendations
      extends Effect[StartRecommendationsRequest, AwsError, Unit]
  object DeleteFleetAdvisorCollector
      extends Effect[DeleteFleetAdvisorCollectorRequest, AwsError, Unit]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
      ]
  object DeleteFleetAdvisorDatabases
      extends Effect[
        DeleteFleetAdvisorDatabasesRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
      ]
  object CreateEndpoint
      extends Effect[
        CreateEndpointRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
      ]
  object CreateReplicationConfig
      extends Effect[
        CreateReplicationConfigRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly
      ]
  object DescribeFleetAdvisorLsaAnalysis
      extends Stream[
        DescribeFleetAdvisorLsaAnalysisRequest,
        AwsError,
        zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
      ]
  object DescribeFleetAdvisorLsaAnalysisPaginated
      extends Effect[
        DescribeFleetAdvisorLsaAnalysisRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
      ]
  object DescribeEventSubscriptions
      extends Effect[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
      ]
  object DescribeEndpointTypes
      extends Effect[
        DescribeEndpointTypesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
      ]
  object DescribeConnections
      extends Effect[
        DescribeConnectionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
      ]
  object RunFleetAdvisorLsaAnalysis
      extends Effect[
        Unit,
        AwsError,
        zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
      ]
  object ExportMetadataModelAssessment
      extends Effect[
        ExportMetadataModelAssessmentRequest,
        AwsError,
        zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly
      ]
  object DescribeMigrationProjects
      extends Effect[
        DescribeMigrationProjectsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly
      ]
  object CreateInstanceProfile
      extends Effect[
        CreateInstanceProfileRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateInstanceProfileResponse.ReadOnly
      ]
  object DescribeMetadataModelImports
      extends Effect[
        DescribeMetadataModelImportsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeMetadataModelImportsResponse.ReadOnly
      ]
  object DescribeReplications
      extends Effect[
        DescribeReplicationsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly
      ]
  object DescribeAccountAttributes
      extends Effect[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object DeleteReplicationConfig
      extends Effect[
        DeleteReplicationConfigRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationConfigResponse.ReadOnly
      ]
  object ImportCertificate
      extends Effect[
        ImportCertificateRequest,
        AwsError,
        zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
      ]
  object DescribeDataProviders
      extends Effect[
        DescribeDataProvidersRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly
      ]
  object BatchStartRecommendations
      extends Effect[
        BatchStartRecommendationsRequest,
        AwsError,
        zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly
      ]
  object ReloadTables
      extends Effect[
        ReloadTablesRequest,
        AwsError,
        zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
      ]
  object RebootReplicationInstance
      extends Effect[
        RebootReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
      ]
  object DeleteReplicationTask
      extends Effect[
        DeleteReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
      ]
  object DescribeEvents
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
      ]
  object StartMetadataModelImport
      extends Effect[
        StartMetadataModelImportRequest,
        AwsError,
        zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly
      ]
  object DescribeInstanceProfiles
      extends Effect[
        DescribeInstanceProfilesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DatabaseMigration] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, DatabaseMigration] { rts =>
        zio.ZIO.succeed {
          new DatabaseMigration {
            val api: DatabaseMigrationAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): DatabaseMigration = this
            def modifyInstanceProfile(
                request: ModifyInstanceProfileRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyInstanceProfileResponse.ReadOnly
            ] = proxy(ModifyInstanceProfile, request)
            def describeFleetAdvisorCollectors(
                request: DescribeFleetAdvisorCollectorsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.databasemigration.model.CollectorResponse.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeFleetAdvisorCollectors, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeFleetAdvisorCollectorsPaginated(
                request: DescribeFleetAdvisorCollectorsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
            ] = proxy(DescribeFleetAdvisorCollectorsPaginated, request)
            def stopReplication(request: StopReplicationRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly
            ] = proxy(StopReplication, request)
            def modifyConversionConfiguration(
                request: ModifyConversionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyConversionConfigurationResponse.ReadOnly
            ] = proxy(ModifyConversionConfiguration, request)
            def startMetadataModelAssessment(
                request: StartMetadataModelAssessmentRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly
            ] = proxy(StartMetadataModelAssessment, request)
            def addTagsToResource(request: AddTagsToResourceRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
            ] = proxy(AddTagsToResource, request)
            def describeOrderableReplicationInstances(
                request: DescribeOrderableReplicationInstancesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
            ] = proxy(DescribeOrderableReplicationInstances, request)
            def deleteMigrationProject(
                request: DeleteMigrationProjectRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteMigrationProjectResponse.ReadOnly
            ] = proxy(DeleteMigrationProject, request)
            def deleteDataProvider(request: DeleteDataProviderRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteDataProviderResponse.ReadOnly
            ] = proxy(DeleteDataProvider, request)
            def describeReplicationInstanceTaskLogs(
                request: DescribeReplicationInstanceTaskLogsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
            ] = proxy(DescribeReplicationInstanceTaskLogs, request)
            def describePendingMaintenanceActions(
                request: DescribePendingMaintenanceActionsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
            ] = proxy(DescribePendingMaintenanceActions, request)
            def refreshSchemas(request: RefreshSchemasRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
            ] = proxy(RefreshSchemas, request)
            def describeTableStatistics(
                request: DescribeTableStatisticsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
            ] = proxy(DescribeTableStatistics, request)
            def deleteReplicationSubnetGroup(
                request: DeleteReplicationSubnetGroupRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
            ] = proxy(DeleteReplicationSubnetGroup, request)
            def stopReplicationTask(request: StopReplicationTaskRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
            ] = proxy(StopReplicationTask, request)
            def startMetadataModelExportToTarget(
                request: StartMetadataModelExportToTargetRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly
            ] = proxy(StartMetadataModelExportToTarget, request)
            def cancelReplicationTaskAssessmentRun(
                request: CancelReplicationTaskAssessmentRunRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
            ] = proxy(CancelReplicationTaskAssessmentRun, request)
            def describeMetadataModelExportsToTarget(
                request: DescribeMetadataModelExportsToTargetRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeMetadataModelExportsToTargetResponse.ReadOnly
            ] = proxy(DescribeMetadataModelExportsToTarget, request)
            def describeRefreshSchemasStatus(
                request: DescribeRefreshSchemasStatusRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
            ] = proxy(DescribeRefreshSchemasStatus, request)
            def startReplicationTask(request: StartReplicationTaskRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
            ] = proxy(StartReplicationTask, request)
            def describeCertificates(request: DescribeCertificatesRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
            ] = proxy(DescribeCertificates, request)
            def modifyReplicationTask(
                request: ModifyReplicationTaskRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
            ] = proxy(ModifyReplicationTask, request)
            def deleteEventSubscription(
                request: DeleteEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
            ] = proxy(DeleteEventSubscription, request)
            def moveReplicationTask(request: MoveReplicationTaskRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
            ] = proxy(MoveReplicationTask, request)
            def modifyMigrationProject(
                request: ModifyMigrationProjectRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyMigrationProjectResponse.ReadOnly
            ] = proxy(ModifyMigrationProject, request)
            def startReplicationTaskAssessment(
                request: StartReplicationTaskAssessmentRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
            ] = proxy(StartReplicationTaskAssessment, request)
            def describeReplicationSubnetGroups(
                request: DescribeReplicationSubnetGroupsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
            ] = proxy(DescribeReplicationSubnetGroups, request)
            def startReplication(request: StartReplicationRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.StartReplicationResponse.ReadOnly
            ] = proxy(StartReplication, request)
            def describeFleetAdvisorSchemaObjectSummary(
                request: DescribeFleetAdvisorSchemaObjectSummaryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeFleetAdvisorSchemaObjectSummary, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeFleetAdvisorSchemaObjectSummaryPaginated(
                request: DescribeFleetAdvisorSchemaObjectSummaryRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly
            ] = proxy(DescribeFleetAdvisorSchemaObjectSummaryPaginated, request)
            def removeTagsFromResource(
                request: RemoveTagsFromResourceRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
            ] = proxy(RemoveTagsFromResource, request)
            def createMigrationProject(
                request: CreateMigrationProjectRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateMigrationProjectResponse.ReadOnly
            ] = proxy(CreateMigrationProject, request)
            def describeReplicationTasks(
                request: DescribeReplicationTasksRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
            ] = proxy(DescribeReplicationTasks, request)
            def createReplicationSubnetGroup(
                request: CreateReplicationSubnetGroupRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
            ] = proxy(CreateReplicationSubnetGroup, request)
            def describeReplicationTaskIndividualAssessments(
                request: DescribeReplicationTaskIndividualAssessmentsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
            ] = proxy(DescribeReplicationTaskIndividualAssessments, request)
            def applyPendingMaintenanceAction(
                request: ApplyPendingMaintenanceActionRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
            ] = proxy(ApplyPendingMaintenanceAction, request)
            def describeExtensionPackAssociations(
                request: DescribeExtensionPackAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeExtensionPackAssociationsResponse.ReadOnly
            ] = proxy(DescribeExtensionPackAssociations, request)
            def createDataProvider(request: CreateDataProviderRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateDataProviderResponse.ReadOnly
            ] = proxy(CreateDataProvider, request)
            def describeReplicationTaskAssessmentResults(
                request: DescribeReplicationTaskAssessmentResultsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
            ] = proxy(DescribeReplicationTaskAssessmentResults, request)
            def describeReplicationTableStatistics(
                request: DescribeReplicationTableStatisticsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly
            ] = proxy(DescribeReplicationTableStatistics, request)
            def deleteCertificate(request: DeleteCertificateRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
            ] = proxy(DeleteCertificate, request)
            def deleteEndpoint(request: DeleteEndpointRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
            ] = proxy(DeleteEndpoint, request)
            def modifyReplicationSubnetGroup(
                request: ModifyReplicationSubnetGroupRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
            ] = proxy(ModifyReplicationSubnetGroup, request)
            def describeRecommendationLimitations(
                request: DescribeRecommendationLimitationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.databasemigration.model.Limitation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeRecommendationLimitations, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeRecommendationLimitationsPaginated(
                request: DescribeRecommendationLimitationsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeRecommendationLimitationsResponse.ReadOnly
            ] = proxy(DescribeRecommendationLimitationsPaginated, request)
            def startExtensionPackAssociation(
                request: StartExtensionPackAssociationRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly
            ] = proxy(StartExtensionPackAssociation, request)
            def modifyReplicationInstance(
                request: ModifyReplicationInstanceRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
            ] = proxy(ModifyReplicationInstance, request)
            def startMetadataModelConversion(
                request: StartMetadataModelConversionRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly
            ] = proxy(StartMetadataModelConversion, request)
            def testConnection(request: TestConnectionRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
            ] = proxy(TestConnection, request)
            def describeMetadataModelExportsAsScript(
                request: DescribeMetadataModelExportsAsScriptRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse.ReadOnly
            ] = proxy(DescribeMetadataModelExportsAsScript, request)
            def deleteReplicationTaskAssessmentRun(
                request: DeleteReplicationTaskAssessmentRunRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
            ] = proxy(DeleteReplicationTaskAssessmentRun, request)
            def describeFleetAdvisorSchemas(
                request: DescribeFleetAdvisorSchemasRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.databasemigration.model.SchemaResponse.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeFleetAdvisorSchemas, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeFleetAdvisorSchemasPaginated(
                request: DescribeFleetAdvisorSchemasRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
            ] = proxy(DescribeFleetAdvisorSchemasPaginated, request)
            def createReplicationTask(
                request: CreateReplicationTaskRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
            ] = proxy(CreateReplicationTask, request)
            def describeMetadataModelConversions(
                request: DescribeMetadataModelConversionsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeMetadataModelConversionsResponse.ReadOnly
            ] = proxy(DescribeMetadataModelConversions, request)
            def describeFleetAdvisorDatabases(
                request: DescribeFleetAdvisorDatabasesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeFleetAdvisorDatabases, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeFleetAdvisorDatabasesPaginated(
                request: DescribeFleetAdvisorDatabasesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
            ] = proxy(DescribeFleetAdvisorDatabasesPaginated, request)
            def describeRecommendations(
                request: DescribeRecommendationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.databasemigration.model.Recommendation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeRecommendations, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeRecommendationsPaginated(
                request: DescribeRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly
            ] = proxy(DescribeRecommendationsPaginated, request)
            def modifyEventSubscription(
                request: ModifyEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
            ] = proxy(ModifyEventSubscription, request)
            def updateSubscriptionsToEventBridge(
                request: UpdateSubscriptionsToEventBridgeRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
            ] = proxy(UpdateSubscriptionsToEventBridge, request)
            def modifyDataProvider(request: ModifyDataProviderRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyDataProviderResponse.ReadOnly
            ] = proxy(ModifyDataProvider, request)
            def describeReplicationInstances(
                request: DescribeReplicationInstancesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
            ] = proxy(DescribeReplicationInstances, request)
            def startMetadataModelExportAsScript(
                request: StartMetadataModelExportAsScriptRequest
            ): IO[AwsError, ReadOnly] =
              proxy(StartMetadataModelExportAsScript, request)
            def describeEventCategories(
                request: DescribeEventCategoriesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
            ] = proxy(DescribeEventCategories, request)
            def createReplicationInstance(
                request: CreateReplicationInstanceRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
            ] = proxy(CreateReplicationInstance, request)
            def deleteReplicationInstance(
                request: DeleteReplicationInstanceRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
            ] = proxy(DeleteReplicationInstance, request)
            def modifyReplicationConfig(
                request: ModifyReplicationConfigRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyReplicationConfigResponse.ReadOnly
            ] = proxy(ModifyReplicationConfig, request)
            def describeReplicationConfigs(
                request: DescribeReplicationConfigsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationConfigsResponse.ReadOnly
            ] = proxy(DescribeReplicationConfigs, request)
            def describeEngineVersions(
                request: DescribeEngineVersionsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly
            ] = proxy(DescribeEngineVersions, request)
            def createFleetAdvisorCollector(
                request: CreateFleetAdvisorCollectorRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
            ] = proxy(CreateFleetAdvisorCollector, request)
            def deleteInstanceProfile(
                request: DeleteInstanceProfileRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly
            ] = proxy(DeleteInstanceProfile, request)
            def describeApplicableIndividualAssessments(
                request: DescribeApplicableIndividualAssessmentsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
            ] = proxy(DescribeApplicableIndividualAssessments, request)
            def describeReplicationTaskAssessmentRuns(
                request: DescribeReplicationTaskAssessmentRunsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
            ] = proxy(DescribeReplicationTaskAssessmentRuns, request)
            def describeMetadataModelAssessments(
                request: DescribeMetadataModelAssessmentsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly
            ] = proxy(DescribeMetadataModelAssessments, request)
            def reloadReplicationTables(
                request: ReloadReplicationTablesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly
            ] = proxy(ReloadReplicationTables, request)
            def describeEndpoints(request: DescribeEndpointsRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
            ] = proxy(DescribeEndpoints, request)
            def startReplicationTaskAssessmentRun(
                request: StartReplicationTaskAssessmentRunRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
            ] = proxy(StartReplicationTaskAssessmentRun, request)
            def describeSchemas(request: DescribeSchemasRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
            ] = proxy(DescribeSchemas, request)
            def createEventSubscription(
                request: CreateEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
            ] = proxy(CreateEventSubscription, request)
            def describeConversionConfiguration(
                request: DescribeConversionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeConversionConfigurationResponse.ReadOnly
            ] = proxy(DescribeConversionConfiguration, request)
            def describeEndpointSettings(
                request: DescribeEndpointSettingsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
            ] = proxy(DescribeEndpointSettings, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def modifyEndpoint(request: ModifyEndpointRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
            ] = proxy(ModifyEndpoint, request)
            def startRecommendations(
                request: StartRecommendationsRequest
            ): IO[AwsError, Unit] = proxy(StartRecommendations, request)
            def deleteFleetAdvisorCollector(
                request: DeleteFleetAdvisorCollectorRequest
            ): IO[AwsError, Unit] = proxy(DeleteFleetAdvisorCollector, request)
            def deleteConnection(request: DeleteConnectionRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
            ] = proxy(DeleteConnection, request)
            def deleteFleetAdvisorDatabases(
                request: DeleteFleetAdvisorDatabasesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
            ] = proxy(DeleteFleetAdvisorDatabases, request)
            def createEndpoint(request: CreateEndpointRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
            ] = proxy(CreateEndpoint, request)
            def createReplicationConfig(
                request: CreateReplicationConfigRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly
            ] = proxy(CreateReplicationConfig, request)
            def describeFleetAdvisorLsaAnalysis(
                request: DescribeFleetAdvisorLsaAnalysisRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeFleetAdvisorLsaAnalysis, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeFleetAdvisorLsaAnalysisPaginated(
                request: DescribeFleetAdvisorLsaAnalysisRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
            ] = proxy(DescribeFleetAdvisorLsaAnalysisPaginated, request)
            def describeEventSubscriptions(
                request: DescribeEventSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
            ] = proxy(DescribeEventSubscriptions, request)
            def describeEndpointTypes(
                request: DescribeEndpointTypesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
            ] = proxy(DescribeEndpointTypes, request)
            def describeConnections(request: DescribeConnectionsRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
            ] = proxy(DescribeConnections, request)
            def runFleetAdvisorLsaAnalysis(): IO[
              AwsError,
              zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
            ] = proxy(RunFleetAdvisorLsaAnalysis)
            def exportMetadataModelAssessment(
                request: ExportMetadataModelAssessmentRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly
            ] = proxy(ExportMetadataModelAssessment, request)
            def describeMigrationProjects(
                request: DescribeMigrationProjectsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly
            ] = proxy(DescribeMigrationProjects, request)
            def createInstanceProfile(
                request: CreateInstanceProfileRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.CreateInstanceProfileResponse.ReadOnly
            ] = proxy(CreateInstanceProfile, request)
            def describeMetadataModelImports(
                request: DescribeMetadataModelImportsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeMetadataModelImportsResponse.ReadOnly
            ] = proxy(DescribeMetadataModelImports, request)
            def describeReplications(request: DescribeReplicationsRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly
            ] = proxy(DescribeReplications, request)
            def describeAccountAttributes(
                request: DescribeAccountAttributesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
            ] = proxy(DescribeAccountAttributes, request)
            def deleteReplicationConfig(
                request: DeleteReplicationConfigRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteReplicationConfigResponse.ReadOnly
            ] = proxy(DeleteReplicationConfig, request)
            def importCertificate(request: ImportCertificateRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
            ] = proxy(ImportCertificate, request)
            def describeDataProviders(
                request: DescribeDataProvidersRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeDataProvidersResponse.ReadOnly
            ] = proxy(DescribeDataProviders, request)
            def batchStartRecommendations(
                request: BatchStartRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly
            ] = proxy(BatchStartRecommendations, request)
            def reloadTables(request: ReloadTablesRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
            ] = proxy(ReloadTables, request)
            def rebootReplicationInstance(
                request: RebootReplicationInstanceRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
            ] = proxy(RebootReplicationInstance, request)
            def deleteReplicationTask(
                request: DeleteReplicationTaskRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
            ] = proxy(DeleteReplicationTask, request)
            def describeEvents(request: DescribeEventsRequest): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
            ] = proxy(DescribeEvents, request)
            def startMetadataModelImport(
                request: StartMetadataModelImportRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly
            ] = proxy(StartMetadataModelImport, request)
            def describeInstanceProfiles(
                request: DescribeInstanceProfilesRequest
            ): IO[
              AwsError,
              zio.aws.databasemigration.model.DescribeInstanceProfilesResponse.ReadOnly
            ] = proxy(DescribeInstanceProfiles, request)
          }
        }
      }
    }
  }
}
