package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportMetadataModelAssessmentRequest(
    migrationProjectIdentifier: String,
    selectionRules: String,
    fileName: Optional[String] = Optional.Absent,
    assessmentReportTypes: Optional[
      Iterable[zio.aws.databasemigration.model.AssessmentReportType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest = {
    import ExportMetadataModelAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .selectionRules(selectionRules: java.lang.String)
      .optionallyWith(fileName.map(value => value: java.lang.String))(
        _.fileName
      )
      .optionallyWith(
        assessmentReportTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.assessmentReportTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest.ReadOnly =
    zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest
      .wrap(buildAwsValue())
}
object ExportMetadataModelAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest =
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest(
        migrationProjectIdentifier,
        selectionRules,
        fileName.map(value => value),
        assessmentReportTypes.map(value => value)
      )
    def migrationProjectIdentifier: String
    def selectionRules: String
    def fileName: Optional[String]
    def assessmentReportTypes
        : Optional[List[zio.aws.databasemigration.model.AssessmentReportType]]
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getSelectionRules: ZIO[Any, Nothing, String] =
      ZIO.succeed(selectionRules)
    def getFileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fileName", fileName)
    def getAssessmentReportTypes: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.AssessmentReportType
    ]] =
      AwsError.unwrapOptionField("assessmentReportTypes", assessmentReportTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest
  ) extends zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val selectionRules: String = impl.selectionRules(): String
    override val fileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fileName())
      .map(value => value: String)
    override val assessmentReportTypes
        : Optional[List[zio.aws.databasemigration.model.AssessmentReportType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentReportTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.AssessmentReportType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest
  ): zio.aws.databasemigration.model.ExportMetadataModelAssessmentRequest.ReadOnly =
    new Wrapper(impl)
}
