package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class StartMetadataModelExportToTargetRequest(
    migrationProjectIdentifier: String,
    selectionRules: String,
    overwriteExtensionPack: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest = {
    import StartMetadataModelExportToTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .selectionRules(selectionRules: java.lang.String)
      .optionallyWith(
        overwriteExtensionPack.map(value => value: java.lang.Boolean)
      )(_.overwriteExtensionPack)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest
      .wrap(buildAwsValue())
}
object StartMetadataModelExportToTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest =
      zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest(
        migrationProjectIdentifier,
        selectionRules,
        overwriteExtensionPack.map(value => value)
      )
    def migrationProjectIdentifier: String
    def selectionRules: String
    def overwriteExtensionPack: Optional[BooleanOptional]
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getSelectionRules: ZIO[Any, Nothing, String] =
      ZIO.succeed(selectionRules)
    def getOverwriteExtensionPack: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "overwriteExtensionPack",
        overwriteExtensionPack
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest
  ) extends zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val selectionRules: String = impl.selectionRules(): String
    override val overwriteExtensionPack: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overwriteExtensionPack())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest
  ): zio.aws.databasemigration.model.StartMetadataModelExportToTargetRequest.ReadOnly =
    new Wrapper(impl)
}
