package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModifyReplicationTaskRequest(
    replicationTaskArn: String,
    replicationTaskIdentifier: Optional[String] = Optional.Absent,
    migrationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    tableMappings: Optional[String] = Optional.Absent,
    replicationTaskSettings: Optional[String] = Optional.Absent,
    cdcStartTime: Optional[TStamp] = Optional.Absent,
    cdcStartPosition: Optional[String] = Optional.Absent,
    cdcStopPosition: Optional[String] = Optional.Absent,
    taskData: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest = {
    import ModifyReplicationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
      .builder()
      .replicationTaskArn(replicationTaskArn: java.lang.String)
      .optionallyWith(
        replicationTaskIdentifier.map(value => value: java.lang.String)
      )(_.replicationTaskIdentifier)
      .optionallyWith(migrationType.map(value => value.unwrap))(_.migrationType)
      .optionallyWith(tableMappings.map(value => value: java.lang.String))(
        _.tableMappings
      )
      .optionallyWith(
        replicationTaskSettings.map(value => value: java.lang.String)
      )(_.replicationTaskSettings)
      .optionallyWith(cdcStartTime.map(value => TStamp.unwrap(value): Instant))(
        _.cdcStartTime
      )
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .optionallyWith(taskData.map(value => value: java.lang.String))(
        _.taskData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationTaskRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationTaskRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationTaskRequest =
      zio.aws.databasemigration.model.ModifyReplicationTaskRequest(
        replicationTaskArn,
        replicationTaskIdentifier.map(value => value),
        migrationType.map(value => value),
        tableMappings.map(value => value),
        replicationTaskSettings.map(value => value),
        cdcStartTime.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value),
        taskData.map(value => value)
      )
    def replicationTaskArn: String
    def replicationTaskIdentifier: Optional[String]
    def migrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def tableMappings: Optional[String]
    def replicationTaskSettings: Optional[String]
    def cdcStartTime: Optional[TStamp]
    def cdcStartPosition: Optional[String]
    def cdcStopPosition: Optional[String]
    def taskData: Optional[String]
    def getReplicationTaskArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskArn)
    def getReplicationTaskIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskIdentifier", replicationTaskIdentifier)
    def getMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("migrationType", migrationType)
    def getTableMappings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableMappings", tableMappings)
    def getReplicationTaskSettings: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskSettings", replicationTaskSettings)
    def getCdcStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getTaskData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskData", taskData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
  ) extends zio.aws.databasemigration.model.ModifyReplicationTaskRequest.ReadOnly {
    override val replicationTaskArn: String = impl.replicationTaskArn(): String
    override val replicationTaskIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskIdentifier())
        .map(value => value: String)
    override val migrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val tableMappings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableMappings())
      .map(value => value: String)
    override val replicationTaskSettings: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskSettings())
        .map(value => value: String)
    override val cdcStartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartPosition())
      .map(value => value: String)
    override val cdcStopPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStopPosition())
      .map(value => value: String)
    override val taskData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskData())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
  ): zio.aws.databasemigration.model.ModifyReplicationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
