package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait EncodingTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue
}
object EncodingTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue
  ): zio.aws.databasemigration.model.EncodingTypeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.PLAIN =>
      val r = plain
      r
    case software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.PLAIN_DICTIONARY =>
      val r = `plain-dictionary`
      r
    case software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.RLE_DICTIONARY =>
      val r = `rle-dictionary`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.EncodingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object plain extends zio.aws.databasemigration.model.EncodingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.PLAIN
  }
  case object `plain-dictionary`
      extends zio.aws.databasemigration.model.EncodingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.PLAIN_DICTIONARY
  }
  case object `rle-dictionary`
      extends zio.aws.databasemigration.model.EncodingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EncodingTypeValue.RLE_DICTIONARY
  }
}
