package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMigrationProjectRequest(
    migrationProjectName: Optional[String] = Optional.Absent,
    sourceDataProviderDescriptors: Iterable[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition
    ],
    targetDataProviderDescriptors: Iterable[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition
    ],
    instanceProfileIdentifier: String,
    transformationRules: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent,
    schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest = {
    import CreateMigrationProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest
      .builder()
      .optionallyWith(
        migrationProjectName.map(value => value: java.lang.String)
      )(_.migrationProjectName)
      .sourceDataProviderDescriptors(sourceDataProviderDescriptors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .targetDataProviderDescriptors(targetDataProviderDescriptors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .instanceProfileIdentifier(instanceProfileIdentifier: java.lang.String)
      .optionallyWith(
        transformationRules.map(value => value: java.lang.String)
      )(_.transformationRules)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        schemaConversionApplicationAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.schemaConversionApplicationAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateMigrationProjectRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateMigrationProjectRequest
      .wrap(buildAwsValue())
}
object CreateMigrationProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateMigrationProjectRequest =
      zio.aws.databasemigration.model.CreateMigrationProjectRequest(
        migrationProjectName.map(value => value),
        sourceDataProviderDescriptors.map { item =>
          item.asEditable
        },
        targetDataProviderDescriptors.map { item =>
          item.asEditable
        },
        instanceProfileIdentifier,
        transformationRules.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schemaConversionApplicationAttributes.map(value => value.asEditable)
      )
    def migrationProjectName: Optional[String]
    def sourceDataProviderDescriptors: List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]
    def targetDataProviderDescriptors: List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]
    def instanceProfileIdentifier: String
    def transformationRules: Optional[String]
    def description: Optional[String]
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ]
    def getMigrationProjectName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("migrationProjectName", migrationProjectName)
    def getSourceDataProviderDescriptors: ZIO[Any, Nothing, List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]] = ZIO.succeed(sourceDataProviderDescriptors)
    def getTargetDataProviderDescriptors: ZIO[Any, Nothing, List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]] = ZIO.succeed(targetDataProviderDescriptors)
    def getInstanceProfileIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(instanceProfileIdentifier)
    def getTransformationRules: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transformationRules", transformationRules)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getSchemaConversionApplicationAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "schemaConversionApplicationAttributes",
      schemaConversionApplicationAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest
  ) extends zio.aws.databasemigration.model.CreateMigrationProjectRequest.ReadOnly {
    override val migrationProjectName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationProjectName())
      .map(value => value: String)
    override val sourceDataProviderDescriptors: List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ] = impl
      .sourceDataProviderDescriptors()
      .asScala
      .map { item =>
        zio.aws.databasemigration.model.DataProviderDescriptorDefinition
          .wrap(item)
      }
      .toList
    override val targetDataProviderDescriptors: List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ] = impl
      .targetDataProviderDescriptors()
      .asScala
      .map { item =>
        zio.aws.databasemigration.model.DataProviderDescriptorDefinition
          .wrap(item)
      }
      .toList
    override val instanceProfileIdentifier: String =
      impl.instanceProfileIdentifier(): String
    override val transformationRules: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transformationRules())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
    override val schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaConversionApplicationAttributes())
      .map(value =>
        zio.aws.databasemigration.model.SCApplicationAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest
  ): zio.aws.databasemigration.model.CreateMigrationProjectRequest.ReadOnly =
    new Wrapper(impl)
}
