package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataProviderRequest(
    dataProviderName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    engine: String,
    settings: zio.aws.databasemigration.model.DataProviderSettings,
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest = {
    import CreateDataProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest
      .builder()
      .optionallyWith(dataProviderName.map(value => value: java.lang.String))(
        _.dataProviderName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .engine(engine: java.lang.String)
      .settings(settings.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateDataProviderRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateDataProviderRequest
      .wrap(buildAwsValue())
}
object CreateDataProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CreateDataProviderRequest =
      zio.aws.databasemigration.model.CreateDataProviderRequest(
        dataProviderName.map(value => value),
        description.map(value => value),
        engine,
        settings.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dataProviderName: Optional[String]
    def description: Optional[String]
    def engine: String
    def settings: zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def getDataProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataProviderName", dataProviderName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getSettings: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    ] = ZIO.succeed(settings)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest
  ) extends zio.aws.databasemigration.model.CreateDataProviderRequest.ReadOnly {
    override val dataProviderName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataProviderName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val engine: String = impl.engine(): String
    override val settings
        : zio.aws.databasemigration.model.DataProviderSettings.ReadOnly =
      zio.aws.databasemigration.model.DataProviderSettings.wrap(impl.settings())
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest
  ): zio.aws.databasemigration.model.CreateDataProviderRequest.ReadOnly =
    new Wrapper(impl)
}
