package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  SecretString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DocDbSettings(
    username: Optional[String] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    nestingLevel: Optional[zio.aws.databasemigration.model.NestingLevelValue] =
      Optional.Absent,
    extractDocId: Optional[BooleanOptional] = Optional.Absent,
    docsToInvestigate: Optional[IntegerOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent,
    useUpdateLookUp: Optional[BooleanOptional] = Optional.Absent,
    replicateShardCollections: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DocDbSettings = {
    import DocDbSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DocDbSettings
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(nestingLevel.map(value => value.unwrap))(_.nestingLevel)
      .optionallyWith(extractDocId.map(value => value: java.lang.Boolean))(
        _.extractDocId
      )
      .optionallyWith(docsToInvestigate.map(value => value: Integer))(
        _.docsToInvestigate
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .optionallyWith(useUpdateLookUp.map(value => value: java.lang.Boolean))(
        _.useUpdateLookUp
      )
      .optionallyWith(
        replicateShardCollections.map(value => value: java.lang.Boolean)
      )(_.replicateShardCollections)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DocDbSettings.ReadOnly =
    zio.aws.databasemigration.model.DocDbSettings.wrap(buildAwsValue())
}
object DocDbSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DocDbSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DocDbSettings =
      zio.aws.databasemigration.model.DocDbSettings(
        username.map(value => value),
        password.map(value => value),
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        nestingLevel.map(value => value),
        extractDocId.map(value => value),
        docsToInvestigate.map(value => value),
        kmsKeyId.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value),
        useUpdateLookUp.map(value => value),
        replicateShardCollections.map(value => value)
      )
    def username: Optional[String]
    def password: Optional[SecretString]
    def serverName: Optional[String]
    def port: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def nestingLevel
        : Optional[zio.aws.databasemigration.model.NestingLevelValue]
    def extractDocId: Optional[BooleanOptional]
    def docsToInvestigate: Optional[IntegerOptional]
    def kmsKeyId: Optional[String]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def useUpdateLookUp: Optional[BooleanOptional]
    def replicateShardCollections: Optional[BooleanOptional]
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getNestingLevel: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.NestingLevelValue
    ] = AwsError.unwrapOptionField("nestingLevel", nestingLevel)
    def getExtractDocId: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("extractDocId", extractDocId)
    def getDocsToInvestigate: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("docsToInvestigate", docsToInvestigate)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
    def getUseUpdateLookUp: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useUpdateLookUp", useUpdateLookUp)
    def getReplicateShardCollections: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "replicateShardCollections",
        replicateShardCollections
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DocDbSettings
  ) extends zio.aws.databasemigration.model.DocDbSettings.ReadOnly {
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val nestingLevel
        : Optional[zio.aws.databasemigration.model.NestingLevelValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nestingLevel())
        .map(value =>
          zio.aws.databasemigration.model.NestingLevelValue.wrap(value)
        )
    override val extractDocId: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.extractDocId())
      .map(value => value: BooleanOptional)
    override val docsToInvestigate: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.docsToInvestigate())
        .map(value => value: IntegerOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
    override val useUpdateLookUp: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useUpdateLookUp())
        .map(value => value: BooleanOptional)
    override val replicateShardCollections: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicateShardCollections())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DocDbSettings
  ): zio.aws.databasemigration.model.DocDbSettings.ReadOnly = new Wrapper(impl)
}
