package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OracleDataProviderSettings(
    serverName: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    asmServer: Optional[String] = Optional.Absent,
    secretsManagerOracleAsmSecretId: Optional[String] = Optional.Absent,
    secretsManagerOracleAsmAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecurityDbEncryptionSecretId: Optional[String] =
      Optional.Absent,
    secretsManagerSecurityDbEncryptionAccessRoleArn: Optional[String] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.OracleDataProviderSettings = {
    import OracleDataProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.OracleDataProviderSettings
      .builder()
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(sslMode.map(value => value.unwrap))(_.sslMode)
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(asmServer.map(value => value: java.lang.String))(
        _.asmServer
      )
      .optionallyWith(
        secretsManagerOracleAsmSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerOracleAsmSecretId)
      .optionallyWith(
        secretsManagerOracleAsmAccessRoleArn.map(value =>
          value: java.lang.String
        )
      )(_.secretsManagerOracleAsmAccessRoleArn)
      .optionallyWith(
        secretsManagerSecurityDbEncryptionSecretId.map(value =>
          value: java.lang.String
        )
      )(_.secretsManagerSecurityDbEncryptionSecretId)
      .optionallyWith(
        secretsManagerSecurityDbEncryptionAccessRoleArn.map(value =>
          value: java.lang.String
        )
      )(_.secretsManagerSecurityDbEncryptionAccessRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly =
    zio.aws.databasemigration.model.OracleDataProviderSettings
      .wrap(buildAwsValue())
}
object OracleDataProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.OracleDataProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.OracleDataProviderSettings =
      zio.aws.databasemigration.model.OracleDataProviderSettings(
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        sslMode.map(value => value),
        certificateArn.map(value => value),
        asmServer.map(value => value),
        secretsManagerOracleAsmSecretId.map(value => value),
        secretsManagerOracleAsmAccessRoleArn.map(value => value),
        secretsManagerSecurityDbEncryptionSecretId.map(value => value),
        secretsManagerSecurityDbEncryptionAccessRoleArn.map(value => value)
      )
    def serverName: Optional[String]
    def port: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue]
    def certificateArn: Optional[String]
    def asmServer: Optional[String]
    def secretsManagerOracleAsmSecretId: Optional[String]
    def secretsManagerOracleAsmAccessRoleArn: Optional[String]
    def secretsManagerSecurityDbEncryptionSecretId: Optional[String]
    def secretsManagerSecurityDbEncryptionAccessRoleArn: Optional[String]
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getSslMode
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DmsSslModeValue] =
      AwsError.unwrapOptionField("sslMode", sslMode)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getAsmServer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("asmServer", asmServer)
    def getSecretsManagerOracleAsmSecretId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerOracleAsmSecretId",
        secretsManagerOracleAsmSecretId
      )
    def getSecretsManagerOracleAsmAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerOracleAsmAccessRoleArn",
        secretsManagerOracleAsmAccessRoleArn
      )
    def getSecretsManagerSecurityDbEncryptionSecretId
        : ZIO[Any, AwsError, String] = AwsError.unwrapOptionField(
      "secretsManagerSecurityDbEncryptionSecretId",
      secretsManagerSecurityDbEncryptionSecretId
    )
    def getSecretsManagerSecurityDbEncryptionAccessRoleArn
        : ZIO[Any, AwsError, String] = AwsError.unwrapOptionField(
      "secretsManagerSecurityDbEncryptionAccessRoleArn",
      secretsManagerSecurityDbEncryptionAccessRoleArn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.OracleDataProviderSettings
  ) extends zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly {
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val sslMode
        : Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslMode())
        .map(value =>
          zio.aws.databasemigration.model.DmsSslModeValue.wrap(value)
        )
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val asmServer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.asmServer())
      .map(value => value: String)
    override val secretsManagerOracleAsmSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerOracleAsmSecretId())
        .map(value => value: String)
    override val secretsManagerOracleAsmAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerOracleAsmAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecurityDbEncryptionSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecurityDbEncryptionSecretId())
        .map(value => value: String)
    override val secretsManagerSecurityDbEncryptionAccessRoleArn
        : Optional[String] = zio.aws.core.internal
      .optionalFromNullable(
        impl.secretsManagerSecurityDbEncryptionAccessRoleArn()
      )
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.OracleDataProviderSettings
  ): zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly =
    new Wrapper(impl)
}
